/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.events;

import java.util.List;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityItemPickupEventHandler {
    @SubscribeEvent
    public static void pickupItems(EntityItemPickupEvent event) {
        boolean modified = false;
        ItemEntity entityItem = event.getItem();
        if (entityItem != null) {
            ItemStack is = entityItem.func_92059_d();
            PlayerEntity player = event.getPlayer();
            if (is != null && is.func_77973_b() instanceof ItemChiseledBit) {
                int originalSize = ModUtil.getStackSize(is);
                PlayerInventory inv = player.field_71071_by;
                List<ItemBitBag.BagPos> bags = ItemBitBag.getBags((IInventory)inv);
                boolean seen = ModUtil.containsAtLeastOneOf((IInventory)inv, is);
                if (seen) {
                    for (ItemBitBag.BagPos i : bags) {
                        if (!entityItem.func_70089_S()) continue;
                        modified = EntityItemPickupEventHandler.updateEntity(player, entityItem, i.inv.insertItem(ModUtil.nonNull(entityItem.func_92059_d())), originalSize) || modified;
                    }
                } else {
                    if (ModUtil.getStackSize(is) > is.func_77976_d() && entityItem.func_70089_S()) {
                        ItemStack singleStack = is.func_77946_l();
                        ModUtil.setStackSize(singleStack, singleStack.func_77976_d());
                        if (!player.field_71071_by.func_70441_a(singleStack)) {
                            ModUtil.adjustStackSize(is, -(singleStack.func_77976_d() - ModUtil.getStackSize(is)));
                        }
                    } else {
                        return;
                    }
                    modified = EntityItemPickupEventHandler.updateEntity(player, entityItem, is, originalSize) || modified;
                    for (ItemBitBag.BagPos i : bags) {
                        if (!entityItem.func_70089_S()) continue;
                        modified = EntityItemPickupEventHandler.updateEntity(player, entityItem, i.inv.insertItem(ModUtil.nonNull(entityItem.func_92059_d())), originalSize) || modified;
                    }
                }
            }
            ItemBitBag.cleanupInventory(player, is);
        }
        if (modified) {
            event.setCanceled(true);
        }
    }

    private static boolean updateEntity(PlayerEntity player, ItemEntity ei, ItemStack is, int originalSize) {
        if (is == null) {
            ei.func_70106_y();
            return true;
        }
        int changed = ModUtil.getStackSize(is) - ModUtil.getStackSize(ei.func_92059_d());
        ei.func_92058_a(is);
        return changed != 0;
    }
}

