/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.crafting;

import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.registry.ModRecipeSerializers;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BagDyeing
extends SpecialRecipe {
    public BagDyeing(ResourceLocation name) {
        super(name);
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        dyed_output output = this.getOutput(inv);
        if (output != null) {
            ItemBitBag cfr_ignored_0 = (ItemBitBag)ModItems.ITEM_BIT_BAG_DEFAULT.get();
            return ItemBitBag.dyeBag(output.bag, output.color);
        }
        return ModUtil.getEmptyStack();
    }

    private dyed_output getOutput(CraftingInventory inv) {
        ItemStack bag = null;
        ItemStack dye = null;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack is = inv.func_70301_a(x);
            if (is == null || ModUtil.isEmpty(is)) continue;
            if (is.func_77973_b() == Items.field_151131_as || this.getDye(is) != null) {
                if (dye == null) {
                    dye = is;
                    continue;
                }
                return null;
            }
            if (is.func_77973_b() instanceof ItemBitBag) {
                if (bag == null) {
                    bag = is;
                    continue;
                }
                return null;
            }
            return null;
        }
        if (bag != null && dye != null) {
            return new dyed_output(bag, this.getDye(dye));
        }
        return null;
    }

    private DyeColor getDye(ItemStack is) {
        if (is.func_77973_b() instanceof DyeItem) {
            DyeItem item = (DyeItem)is.func_77973_b();
            return item.func_195962_g();
        }
        return null;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.getOutput(inv) != null;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.BAG_DYEING.get();
    }

    private static class dyed_output {
        ItemStack bag;
        DyeColor color;

        public dyed_output(ItemStack bag, DyeColor dye) {
            this.bag = bag;
            this.color = dye;
        }
    }
}

