/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core;

import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.api.ModKeyBinding;
import mod.chiselsandbits.api.ReplacementStateHandler;
import mod.chiselsandbits.bitstorage.TileEntitySpecialRenderBitStorage;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.chiseledblock.iterators.ChiselIterator;
import mod.chiselsandbits.chiseledblock.iterators.ChiselTypeIterator;
import mod.chiselsandbits.client.BlockColorChisled;
import mod.chiselsandbits.client.CreativeClipboardTab;
import mod.chiselsandbits.client.ItemColorBitBag;
import mod.chiselsandbits.client.ItemColorBits;
import mod.chiselsandbits.client.ItemColorChisled;
import mod.chiselsandbits.client.ItemColorPatterns;
import mod.chiselsandbits.client.ModConflictContext;
import mod.chiselsandbits.client.RenderHelper;
import mod.chiselsandbits.client.TapeMeasures;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.client.gui.ChiselsAndBitsMenu;
import mod.chiselsandbits.client.gui.SpriteIconPositioning;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ReflectionWrapper;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ChiselModeManager;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.helpers.ReadyState;
import mod.chiselsandbits.helpers.VoxelRegionSrc;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.interfaces.IPatternItem;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.modes.PositivePatternMode;
import mod.chiselsandbits.modes.TapeMeasureModes;
import mod.chiselsandbits.network.packets.PacketChisel;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.network.packets.PacketSetColor;
import mod.chiselsandbits.network.packets.PacketSuppressInteraction;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.registry.ModTileEntityTypes;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientSide {
    private static final Random RANDOM = new Random();
    public static final ClientSide instance = new ClientSide();
    ReadyState readyState = ReadyState.PENDING_PRE;
    private final HashMap<IToolMode, SpriteIconPositioning> chiselModeIcons = new HashMap();
    private KeyBinding rotateCCW;
    private KeyBinding rotateCW;
    private KeyBinding undo;
    private KeyBinding redo;
    private KeyBinding modeMenu;
    private KeyBinding addToClipboard;
    private KeyBinding pickBit;
    private KeyBinding offgridPlacement;
    private Stopwatch rotateTimer;
    public final TapeMeasures tapeMeasures = new TapeMeasures();
    public static TextureAtlasSprite undoIcon;
    public static TextureAtlasSprite redoIcon;
    public static TextureAtlasSprite trashIcon;
    public static TextureAtlasSprite sortIcon;
    public static TextureAtlasSprite swapIcon;
    public static TextureAtlasSprite placeIcon;
    public static TextureAtlasSprite roll_x;
    public static TextureAtlasSprite roll_z;
    public static TextureAtlasSprite white;
    boolean wasDrawing = false;
    private ItemStack previousItem;
    private int previousRotations;
    private Object previousModel;
    private Object previousCacheRef;
    private IntegerBox modelBounds;
    private boolean isVisible = true;
    private boolean isUnplaceable = true;
    private BlockPos lastPartial;
    private BlockPos lastPos;
    int displayStatus = 0;
    private BitLocation drawStart;
    private int ticksSinceRelease = 0;
    private int lastRenderedFrame = Integer.MIN_VALUE;
    @Nonnull
    ChiselToolType lastTool = ChiselToolType.CHISEL;
    @Nonnull
    Hand lastHand = Hand.MAIN_HAND;

    public KeyBinding getKeyBinding(ModKeyBinding modKeyBinding) {
        switch (modKeyBinding) {
            case ROTATE_CCW: {
                return this.rotateCCW;
            }
            case ROTATE_CW: {
                return this.rotateCW;
            }
            case UNDO: {
                return this.undo;
            }
            case REDO: {
                return this.redo;
            }
            case ADD_TO_CLIPBOARD: {
                return this.addToClipboard;
            }
            case PICK_BIT: {
                return this.pickBit;
            }
            case OFFGRID_PLACEMENT: {
                return ClientSide.getOffGridPlacementKey();
            }
        }
        return this.modeMenu;
    }

    public void preinit(ChiselsAndBits mod) {
        this.readyState = this.readyState.updateState(ReadyState.TRIGGER_PRE);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    public void init(ChiselsAndBits chiselsandbits) {
        this.readyState = this.readyState.updateState(ReadyState.TRIGGER_INIT);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.BIT_STORAGE.get()), TileEntitySpecialRenderBitStorage::new);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BIT_STORAGE_BLOCK.get()), (RenderType)RenderType.func_228641_d_());
        ModBlocks.getMaterialToBlockConversions().values().stream().map(RegistryObject::get).forEach(b -> RenderTypeLookup.setRenderLayer((Block)b, (Predicate)((com.google.common.base.Predicate)input -> RenderType.func_228661_n_().contains(input))));
        for (ChiselMode chiselMode : ChiselMode.values()) {
            chiselMode.binding = this.registerKeybind(chiselMode.string.toString(), InputMappings.field_197958_a, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_CHISEL);
        }
        for (Enum enum_ : PositivePatternMode.values()) {
            ((PositivePatternMode)enum_).binding = this.registerKeybind(((PositivePatternMode)enum_).string.toString(), InputMappings.field_197958_a, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_POSTIVEPATTERN);
        }
        for (Enum enum_ : TapeMeasureModes.values()) {
            ((TapeMeasureModes)enum_).binding = this.registerKeybind(((TapeMeasureModes)enum_).string.toString(), InputMappings.field_197958_a, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_TAPEMEASURE);
        }
        this.modeMenu = this.registerKeybind("mod.chiselsandbits.other.mode", InputMappings.field_197958_a, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_MENUITEM);
        this.rotateCCW = this.registerKeybind("mod.chiselsandbits.other.rotate.ccw", InputMappings.field_197958_a, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_ROTATEABLE);
        this.rotateCW = this.registerKeybind("mod.chiselsandbits.other.rotate.cw", InputMappings.field_197958_a, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_ROTATEABLE);
        this.pickBit = this.registerKeybind("mod.chiselsandbits.other.pickbit", InputMappings.field_197958_a, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_ROTATEABLE);
        this.offgridPlacement = this.registerKeybind("mod.chiselsandbits.other.offgrid", InputMappings.field_197958_a, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_OFFGRID);
        this.undo = this.registerKeybind("mod.chiselsandbits.other.undo", InputMappings.field_197958_a, "itemGroup.chiselsandbits", (IKeyConflictContext)KeyConflictContext.IN_GAME);
        this.redo = this.registerKeybind("mod.chiselsandbits.other.redo", InputMappings.field_197958_a, "itemGroup.chiselsandbits", (IKeyConflictContext)KeyConflictContext.IN_GAME);
        this.addToClipboard = this.registerKeybind("mod.chiselsandbits.other.add_to_clipboard", InputMappings.field_197958_a, "itemGroup.chiselsandbits", (IKeyConflictContext)KeyConflictContext.IN_GAME);
    }

    private KeyBinding registerKeybind(String bindingName, InputMappings.Input defaultKey, String groupName, IKeyConflictContext context) {
        KeyBinding kb = new KeyBinding(bindingName, context, defaultKey, groupName);
        ClientRegistry.registerKeyBinding((KeyBinding)kb);
        return kb;
    }

    public void postinit(ChiselsAndBits mod) {
        this.readyState = this.readyState.updateState(ReadyState.TRIGGER_POST);
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorBitBag(), new IItemProvider[]{(IItemProvider)ModItems.ITEM_BIT_BAG_DEFAULT.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorBitBag(), new IItemProvider[]{(IItemProvider)ModItems.ITEM_BIT_BAG_DYED.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorBits(), new IItemProvider[]{(IItemProvider)ModItems.ITEM_BLOCK_BIT.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorPatterns(), new IItemProvider[]{(IItemProvider)ModItems.ITEM_POSITIVE_PRINT.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorPatterns(), new IItemProvider[]{(IItemProvider)ModItems.ITEM_POSITIVE_PRINT_WRITTEN.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorPatterns(), new IItemProvider[]{(IItemProvider)ModItems.ITEM_NEGATIVE_PRINT.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorPatterns(), new IItemProvider[]{(IItemProvider)ModItems.ITEM_NEGATIVE_PRINT_WRITTEN.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorPatterns(), new IItemProvider[]{(IItemProvider)ModItems.ITEM_MIRROR_PRINT.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorPatterns(), new IItemProvider[]{(IItemProvider)ModItems.ITEM_MIRROR_PRINT_WRITTEN.get()});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColorChisled(), (Block[])ModBlocks.getMaterialToBlockConversions().values().stream().map(RegistryObject::get).toArray(Block[]::new));
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemColorChisled(), (IItemProvider[])ModBlocks.getMaterialToItemConversions().values().stream().map(RegistryObject::get).toArray(Item[]::new));
    }

    public SpriteIconPositioning getIconForMode(IToolMode mode) {
        return this.chiselModeIcons.get(mode);
    }

    public void setIconForMode(IToolMode mode, SpriteIconPositioning positioning) {
        this.chiselModeIcons.put(mode, positioning);
    }

    @SubscribeEvent
    public void onRenderGUI(RenderGameOverlayEvent.Post event) {
        BlockRayTraceResult rayTraceResult;
        MainWindow window;
        ChiselToolType tool = this.getHeldToolType(this.lastHand);
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.ALL && tool != null && tool.hasMenu()) {
            boolean wasVisible = ChiselsAndBitsMenu.instance.isVisible();
            if (!this.modeMenu.func_197986_j() && this.modeMenu.func_151470_d()) {
                ChiselsAndBitsMenu.instance.actionUsed = false;
                if (ChiselsAndBitsMenu.instance.raiseVisibility()) {
                    ChiselsAndBitsMenu.instance.getMinecraft().field_71417_B.func_198032_j();
                }
            } else {
                if (!ChiselsAndBitsMenu.instance.actionUsed) {
                    if (ChiselsAndBitsMenu.instance.switchTo != null) {
                        instance.playRadialMenu();
                        ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool, Hand.MAIN_HAND), ChiselsAndBitsMenu.instance.switchTo);
                    }
                    if (ChiselsAndBitsMenu.instance.doAction != null) {
                        instance.playRadialMenu();
                        switch (ChiselsAndBitsMenu.instance.doAction) {
                            case ROLL_X: {
                                PacketRotateVoxelBlob pri = new PacketRotateVoxelBlob(Direction.Axis.X, Rotation.CLOCKWISE_90);
                                ChiselsAndBits.getNetworkChannel().sendToServer(pri);
                                break;
                            }
                            case ROLL_Z: {
                                PacketRotateVoxelBlob pri2 = new PacketRotateVoxelBlob(Direction.Axis.Z, Rotation.CLOCKWISE_90);
                                ChiselsAndBits.getNetworkChannel().sendToServer(pri2);
                                break;
                            }
                            case REPLACE_TOGGLE: {
                                ReplacementStateHandler.getInstance().setReplacing(!ReplacementStateHandler.getInstance().isReplacing());
                                ReflectionWrapper.instance.clearHighlightedStack();
                                break;
                            }
                            case UNDO: {
                                UndoTracker.getInstance().undo();
                                break;
                            }
                            case REDO: {
                                UndoTracker.getInstance().redo();
                                break;
                            }
                            case BLACK: 
                            case BLUE: 
                            case BROWN: 
                            case CYAN: 
                            case GRAY: 
                            case GREEN: 
                            case LIGHT_BLUE: 
                            case LIME: 
                            case MAGENTA: 
                            case ORANGE: 
                            case PINK: 
                            case PURPLE: 
                            case RED: 
                            case LIGHT_GRAY: 
                            case WHITE: 
                            case YELLOW: {
                                PacketSetColor setColor = new PacketSetColor(DyeColor.valueOf((String)ChiselsAndBitsMenu.instance.doAction.name()), this.getHeldToolType(Hand.MAIN_HAND), (Boolean)ChiselsAndBits.getConfig().getClient().chatModeNotification.get());
                                ChiselsAndBits.getNetworkChannel().sendToServer(setColor);
                                ReflectionWrapper.instance.clearHighlightedStack();
                            }
                        }
                    }
                }
                ChiselsAndBitsMenu.instance.actionUsed = true;
                ChiselsAndBitsMenu.instance.decreaseVisibility();
            }
            if (ChiselsAndBitsMenu.instance.isVisible()) {
                window = event.getWindow();
                ChiselsAndBitsMenu.instance.func_231158_b_(Minecraft.func_71410_x(), window.func_198107_o(), window.func_198087_p());
                ChiselsAndBitsMenu.instance.configure(window.func_198107_o(), window.func_198087_p());
                if (!wasVisible) {
                    ChiselsAndBitsMenu.instance.getMinecraft().field_71462_r = ChiselsAndBitsMenu.instance;
                    ChiselsAndBitsMenu.instance.getMinecraft().field_71417_B.func_198032_j();
                }
                if (ChiselsAndBitsMenu.instance.getMinecraft().field_71417_B.func_198035_h()) {
                    KeyBinding.func_74506_a();
                }
            } else if (wasVisible) {
                ChiselsAndBitsMenu.instance.getMinecraft().field_71417_B.func_198034_i();
            }
        }
        if (!this.undo.func_197986_j() && this.undo.func_151468_f()) {
            UndoTracker.getInstance().undo();
        }
        if (!this.redo.func_197986_j() && this.redo.func_151468_f()) {
            UndoTracker.getInstance().redo();
        }
        if (!this.addToClipboard.func_197986_j() && this.addToClipboard.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && mc.field_71476_x instanceof BlockRayTraceResult) {
                rayTraceResult = (BlockRayTraceResult)mc.field_71476_x;
                try {
                    IBitAccess access = ChiselsAndBits.getApi().getBitAccess((World)mc.field_71441_e, rayTraceResult.func_216350_a());
                    ItemStack is = access.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
                    CreativeClipboardTab.addItem(is);
                }
                catch (APIExceptions.CannotBeChiseled access) {
                    // empty catch block
                }
            }
        }
        if (!this.pickBit.func_197986_j() && this.pickBit.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && mc.field_71476_x instanceof BlockRayTraceResult) {
                rayTraceResult = (BlockRayTraceResult)mc.field_71476_x;
                try {
                    BitLocation bl = new BitLocation(rayTraceResult, BitOperation.CHISEL);
                    IBitAccess access = ChiselsAndBits.getApi().getBitAccess((World)mc.field_71441_e, bl.getBlockPos());
                    IBitBrush brush = access.getBitAt(bl.getBitX(), bl.getBitY(), bl.getBitZ());
                    ItemStack is = brush.getItemStack(1);
                    this.doPick(is);
                }
                catch (APIExceptions.CannotBeChiseled bl) {
                    // empty catch block
                }
            }
        }
        if (type == RenderGameOverlayEvent.ElementType.HOTBAR && ((Boolean)ChiselsAndBits.getConfig().getClient().enableToolbarIcons.get()).booleanValue()) {
            Minecraft mc = Minecraft.func_71410_x();
            window = event.getWindow();
            if (!mc.field_71439_g.func_175149_v()) {
                IngameGui sc = mc.field_71456_v;
                for (int slot = 0; slot < 9; ++slot) {
                    ItemStack stack = (ItemStack)mc.field_71439_g.field_71071_by.field_70462_a.get(slot);
                    if (!(stack.func_77973_b() instanceof ItemChisel)) continue;
                    ChiselToolType toolType = this.getToolTypeForItem(stack);
                    IToolMode mode = toolType.getMode(stack);
                    if (!((Boolean)ChiselsAndBits.getConfig().getClient().perChiselMode.get()).booleanValue() && tool == ChiselToolType.CHISEL) {
                        mode = ChiselModeManager.getChiselMode((PlayerEntity)mc.field_71439_g, ChiselToolType.CHISEL, this.lastHand);
                    }
                    int x = window.func_198107_o() / 2 - 90 + slot * 20 + 2;
                    int y = window.func_198087_p() - 16 - 3;
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
                    TextureAtlasSprite sprite = this.chiselModeIcons.get(mode) == null ? this.getMissingIcon() : this.chiselModeIcons.get((Object)mode).sprite;
                    RenderSystem.enableBlend();
                    IngameGui.func_238470_a_((MatrixStack)event.getMatrixStack(), (int)(x + 1), (int)(y + 1), (int)0, (int)8, (int)8, (TextureAtlasSprite)sprite);
                    RenderSystem.disableBlend();
                }
            }
        }
    }

    public void playRadialMenu() {
        double volume = (Double)ChiselsAndBits.getConfig().getClient().radialMenuVolume.get();
        if (volume >= (double)1.0E-4f) {
            SimpleSound psr = new SimpleSound(SoundEvents.field_187909_gi, SoundCategory.MASTER, (float)volume, 1.0f, this.getPlayer().func_233580_cy_());
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)psr);
        }
    }

    private boolean doPick(@Nonnull ItemStack result) {
        PlayerEntity player = this.getPlayer();
        for (int x = 0; x < 9; ++x) {
            ItemStack stack = player.field_71071_by.func_70301_a(x);
            if (stack == null || !stack.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)result)) continue;
            player.field_71071_by.field_70461_c = x;
            return true;
        }
        if (!player.func_184812_l_()) {
            return false;
        }
        int slot = player.field_71071_by.func_70447_i();
        if (slot < 0 || slot >= 9) {
            slot = player.field_71071_by.field_70461_c;
        }
        player.field_71071_by.func_70299_a(slot, result);
        player.field_71071_by.field_70461_c = slot;
        int j = player.field_71069_bz.field_75151_b.size() - 9 + player.field_71071_by.field_70461_c;
        Minecraft.func_71410_x().field_71442_b.func_78761_a(player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c), j);
        return true;
    }

    public ChiselToolType getHeldToolType(Hand Hand2) {
        PlayerEntity player = this.getPlayer();
        if (player == null) {
            return null;
        }
        ItemStack is = player.func_184586_b(Hand2);
        return this.getToolTypeForItem(is);
    }

    private ChiselToolType getToolTypeForItem(ItemStack is) {
        if (is != null && is.func_77973_b() instanceof ItemChisel) {
            return ChiselToolType.CHISEL;
        }
        if (is != null && is.func_77973_b() instanceof ItemChiseledBit) {
            return ChiselToolType.BIT;
        }
        if (is != null && is.func_77973_b() instanceof ItemBlockChiseled) {
            return ChiselToolType.CHISELED_BLOCK;
        }
        if (is != null && is.func_77973_b() == ModItems.ITEM_TAPE_MEASURE.get()) {
            return ChiselToolType.TAPEMEASURE;
        }
        if (is != null && is.func_77973_b() == ModItems.ITEM_POSITIVE_PRINT.get()) {
            return ChiselToolType.POSITIVEPATTERN;
        }
        if (is != null && is.func_77973_b() == ModItems.ITEM_POSITIVE_PRINT_WRITTEN.get()) {
            return ChiselToolType.POSITIVEPATTERN;
        }
        if (is != null && is.func_77973_b() == ModItems.ITEM_NEGATIVE_PRINT.get()) {
            return ChiselToolType.NEGATIVEPATTERN;
        }
        if (is != null && is.func_77973_b() == ModItems.ITEM_NEGATIVE_PRINT_WRITTEN.get()) {
            return ChiselToolType.NEGATIVEPATTERN;
        }
        if (is != null && is.func_77973_b() == ModItems.ITEM_MIRROR_PRINT.get()) {
            return ChiselToolType.MIRRORPATTERN;
        }
        if (is != null && is.func_77973_b() == ModItems.ITEM_MIRROR_PRINT_WRITTEN.get()) {
            return ChiselToolType.MIRRORPATTERN;
        }
        return null;
    }

    @SubscribeEvent
    public void drawingInteractionPrevention(PlayerInteractEvent.RightClickBlock pie) {
        if (pie.getWorld() != null && pie.getWorld().field_72995_K) {
            ChiselToolType tool = this.getHeldToolType(pie.getHand());
            IToolMode chMode = ChiselModeManager.getChiselMode(this.getPlayer(), tool, pie.getHand());
            BitLocation other = this.getStartPos();
            if ((chMode == ChiselMode.DRAWN_REGION || tool == ChiselToolType.TAPEMEASURE) && other != null) {
                pie.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void interaction(TickEvent.ClientTickEvent event) {
        ChiselToolType tool;
        KeyBinding kb;
        PacketRotateVoxelBlob p;
        if (!this.readyState.isReady()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g != null && !Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g().func_190926_b()) {
            this.lastTool = this.getToolTypeForItem(Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g).field_71071_by.func_70448_g());
        }
        if (event.side == LogicalSide.CLIENT && event.type == TickEvent.Type.CLIENT && event.phase == TickEvent.Phase.START && !Minecraft.func_71410_x().field_71474_y.field_74312_F.func_197986_j() && !Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d()) {
            ItemChisel.resetDelay();
        }
        if (!this.getToolKey().func_197986_j() && !this.getToolKey().func_151470_d() && this.lastTool == ChiselToolType.CHISEL) {
            if (this.ticksSinceRelease >= 4) {
                if (this.drawStart != null) {
                    this.drawStart = null;
                    this.lastHand = Hand.MAIN_HAND;
                }
                this.lastTool = ChiselToolType.CHISEL;
                this.ticksSinceRelease = 0;
            } else {
                ++this.ticksSinceRelease;
            }
        } else {
            this.ticksSinceRelease = 0;
        }
        if (!this.rotateCCW.func_197986_j() && this.rotateCCW.func_151470_d() && (this.rotateTimer == null || this.rotateTimer.elapsed(TimeUnit.MILLISECONDS) > 200L)) {
            this.rotateTimer = Stopwatch.createStarted();
            p = new PacketRotateVoxelBlob(Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90);
            ChiselsAndBits.getNetworkChannel().sendToServer(p);
        }
        if (!this.rotateCW.func_197986_j() && this.rotateCW.func_151470_d() && (this.rotateTimer == null || this.rotateTimer.elapsed(TimeUnit.MILLISECONDS) > 200L)) {
            this.rotateTimer = Stopwatch.createStarted();
            p = new PacketRotateVoxelBlob(Direction.Axis.Y, Rotation.CLOCKWISE_90);
            ChiselsAndBits.getNetworkChannel().sendToServer(p);
        }
        for (ChiselMode chiselMode : ChiselMode.values()) {
            kb = (KeyBinding)chiselMode.binding;
            if (kb.func_197986_j() || !kb.func_151470_d() || !(tool = this.getHeldToolType(this.lastHand)).isBitOrChisel()) continue;
            ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand), chiselMode);
        }
        for (Enum enum_ : PositivePatternMode.values()) {
            kb = (KeyBinding)((PositivePatternMode)enum_).binding;
            if (kb.func_197986_j() || !kb.func_151470_d() || (tool = this.getHeldToolType(this.lastHand)) != ChiselToolType.POSITIVEPATTERN) continue;
            ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand), (IToolMode)((Object)enum_));
        }
        for (Enum enum_ : TapeMeasureModes.values()) {
            kb = (KeyBinding)((TapeMeasureModes)enum_).binding;
            if (kb.func_197986_j() || !kb.func_151470_d() || (tool = this.getHeldToolType(this.lastHand)) != ChiselToolType.TAPEMEASURE) continue;
            ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand), (IToolMode)((Object)enum_));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void drawHighlight(RenderWorldLastEvent event) {
        boolean isDrawing;
        MatrixStack stack = event.getMatrixStack();
        stack.func_227860_a_();
        Vector3d renderView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        stack.func_227861_a_(-renderView.field_72450_a, -renderView.field_72448_b, -renderView.field_72449_c);
        ChiselToolType tool = this.getHeldToolType(this.lastHand);
        IToolMode chMode = ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand);
        if (chMode == ChiselMode.DRAWN_REGION) {
            tool = this.lastTool;
        }
        this.tapeMeasures.setPreviewMeasure(null, null, chMode, null);
        if (tool == ChiselToolType.TAPEMEASURE) {
            PlayerEntity player = this.getPlayer();
            RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
            World theWorld = player.field_70170_p;
            if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BitLocation other;
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)mop;
                BitLocation location = new BitLocation(blockRayTraceResult, BitOperation.CHISEL);
                if (theWorld.func_175723_af().func_177746_a(location.blockPos) && (other = this.getStartPos()) != null) {
                    this.tapeMeasures.setPreviewMeasure(other, location, chMode, this.getPlayer().func_184586_b(this.lastHand));
                    if (!this.getToolKey().func_197986_j() && !this.getToolKey().func_151470_d()) {
                        this.tapeMeasures.addMeasure(other, location, chMode, this.getPlayer().func_184586_b(this.lastHand));
                        this.drawStart = null;
                        this.lastHand = Hand.MAIN_HAND;
                    }
                }
            }
        }
        this.tapeMeasures.render(stack, event.getPartialTicks());
        boolean bl = isDrawing = (chMode == ChiselMode.DRAWN_REGION || tool == ChiselToolType.TAPEMEASURE) && this.getStartPos() != null;
        if (isDrawing != this.wasDrawing) {
            this.wasDrawing = isDrawing;
            PacketSuppressInteraction packet = new PacketSuppressInteraction(isDrawing);
            ChiselsAndBits.getNetworkChannel().sendToServer(packet);
        }
        stack.func_227865_b_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void drawHighlight(DrawHighlightEvent.HighlightBlock event) {
        try {
            MatrixStack stack = event.getMatrix();
            stack.func_227860_a_();
            Vector3d renderView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            stack.func_227861_a_(-renderView.field_72450_a, -renderView.field_72448_b, -renderView.field_72449_c);
            ChiselToolType tool = this.getHeldToolType(this.lastHand);
            IToolMode chMode = ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand);
            if (chMode == ChiselMode.DRAWN_REGION) {
                tool = this.lastTool;
            }
            if (tool != null && tool.isBitOrChisel() && chMode != null) {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                float partialTicks = event.getPartialTicks();
                RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
                World theWorld = player.field_70170_p;
                if (mop == null || mop.func_216346_c() != RayTraceResult.Type.BLOCK) {
                    return;
                }
                boolean showBox = false;
                if (mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)mop;
                    BitLocation location = new BitLocation(rayTraceResult, this.getLastBitOperation((PlayerEntity)player, this.lastHand, this.getPlayer().func_184586_b(this.lastHand)));
                    if (theWorld.func_175723_af().func_177746_a(location.blockPos)) {
                        VoxelBlob vb;
                        BlockState state = theWorld.func_180495_p(location.blockPos);
                        boolean isChisel = this.getDrawnTool() == ChiselToolType.CHISEL;
                        boolean isBit = this.getHeldToolType(Hand.MAIN_HAND) == ChiselToolType.BIT;
                        TileEntityBlockChiseled data = ModUtil.getChiseledTileEntity(theWorld, location.blockPos, false);
                        VoxelRegionSrc region = new VoxelRegionSrc(theWorld, location.blockPos, 1);
                        VoxelBlob voxelBlob = vb = data != null ? data.getBlob() : new VoxelBlob();
                        if (isChisel && data == null) {
                            showBox = true;
                            vb.fill(1);
                        }
                        BitLocation other = this.getStartPos();
                        if (chMode == ChiselMode.DRAWN_REGION && other != null) {
                            ChiselIterator oneEnd = ChiselTypeIterator.create(16, location.bitX, location.bitY, location.bitZ, VoxelBlob.NULL_BLOB, ChiselMode.SINGLE, Direction.UP, tool == ChiselToolType.BIT);
                            ChiselIterator otherEnd = ChiselTypeIterator.create(16, other.bitX, other.bitY, other.bitZ, VoxelBlob.NULL_BLOB, ChiselMode.SINGLE, Direction.UP, tool == ChiselToolType.BIT);
                            AxisAlignedBB a = oneEnd.getBoundingBox(VoxelBlob.NULL_BLOB, false).func_72317_d((double)location.blockPos.func_177958_n(), (double)location.blockPos.func_177956_o(), (double)location.blockPos.func_177952_p());
                            AxisAlignedBB b = otherEnd.getBoundingBox(VoxelBlob.NULL_BLOB, false).func_72317_d((double)other.blockPos.func_177958_n(), (double)other.blockPos.func_177956_o(), (double)other.blockPos.func_177952_p());
                            AxisAlignedBB bb = a.func_111270_a(b);
                            double maxChiseSize = (Double)ChiselsAndBits.getConfig().getClient().maxDrawnRegionSize.get() + 0.001;
                            if (bb.field_72336_d - bb.field_72340_a <= maxChiseSize && bb.field_72337_e - bb.field_72338_b <= maxChiseSize && bb.field_72334_f - bb.field_72339_c <= maxChiseSize) {
                                RenderHelper.drawSelectionBoundingBoxIfExists(event.getMatrix(), bb, BlockPos.field_177992_a, (PlayerEntity)player, partialTicks, false);
                                if (!this.getToolKey().func_197986_j() && !this.getToolKey().func_151470_d()) {
                                    PacketChisel pc = new PacketChisel(this.getLastBitOperation((PlayerEntity)player, this.lastHand, player.func_184586_b(this.lastHand)), location, other, Direction.UP, ChiselMode.DRAWN_REGION, this.lastHand);
                                    if (pc.doAction(this.getPlayer()) > 0) {
                                        ChiselsAndBits.getNetworkChannel().sendToServer(pc);
                                        ClientSide.placeSound(theWorld, location.blockPos, 0);
                                    }
                                    this.drawStart = null;
                                    this.lastHand = Hand.MAIN_HAND;
                                    this.lastTool = ChiselToolType.CHISEL;
                                }
                            }
                        } else {
                            VoxelBlob vx;
                            TileEntityBlockChiseled tebc;
                            TileEntity te = theWorld.func_175726_f(location.blockPos).func_177424_a(location.blockPos, Chunk.CreateEntityType.CHECK);
                            boolean isBitBlock = te instanceof TileEntityBlockChiseled;
                            boolean isBlockSupported = BlockBitInfo.canChisel(state);
                            if (!isBitBlock && !isBlockSupported && (tebc = ModUtil.getChiseledTileEntity(theWorld, location.blockPos, false)) != null && (vx = tebc.getBlob()).get(location.bitX, location.bitY, location.bitZ) != 0) {
                                isBitBlock = true;
                            }
                            if (theWorld.func_175623_d(location.blockPos) || isBitBlock || isBlockSupported) {
                                ChiselIterator i = ChiselTypeIterator.create(16, location.bitX, location.bitY, location.bitZ, region, ChiselMode.castMode(chMode), rayTraceResult.func_216354_b(), !isChisel);
                                AxisAlignedBB bb = i.getBoundingBox(vb, isChisel);
                                RenderHelper.drawSelectionBoundingBoxIfExists(event.getMatrix(), bb, location.blockPos, (PlayerEntity)player, partialTicks, false);
                                showBox = false;
                            } else if (isBit) {
                                VoxelBlob j = new VoxelBlob();
                                j.fill(1);
                                ChiselIterator i = ChiselTypeIterator.create(16, location.bitX, location.bitY, location.bitZ, j, ChiselMode.castMode(chMode), rayTraceResult.func_216354_b(), !isChisel);
                                AxisAlignedBB bb = this.snapToSide(i.getBoundingBox(j, isChisel), rayTraceResult.func_216354_b());
                                RenderHelper.drawSelectionBoundingBoxIfExists(event.getMatrix(), bb, location.blockPos, (PlayerEntity)player, partialTicks, false);
                            }
                        }
                    }
                    if (!showBox) {
                        event.setCanceled(true);
                    }
                }
            }
        }
        finally {
            event.getMatrix().func_227865_b_();
        }
    }

    private BitOperation getLastBitOperation(PlayerEntity player, Hand lastHand2, ItemStack heldItem) {
        return this.lastTool == ChiselToolType.BIT ? ItemChiseledBit.getBitOperation(player, this.lastHand, player.func_184586_b(this.lastHand)) : BitOperation.CHISEL;
    }

    private AxisAlignedBB snapToSide(AxisAlignedBB boundingBox, Direction sideHit) {
        if (boundingBox != null) {
            switch (sideHit) {
                case DOWN: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
                }
                case EAST: {
                    return new AxisAlignedBB(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                }
                case NORTH: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
                }
                case SOUTH: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                }
                case UP: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                }
                case WEST: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
                }
            }
        }
        return boundingBox;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void drawLast(RenderWorldLastEvent event) {
        ++this.lastRenderedFrame;
        if (Minecraft.func_71410_x().field_71474_y.field_74319_N) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float partialTicks = event.getPartialTicks();
        RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
        World theWorld = player.field_70170_p;
        ItemStack currentItem = player.func_184614_ca();
        double x = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.func_226278_cu_() - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * (double)partialTicks;
        if (mop == null) {
            return;
        }
        if (ModUtil.isHoldingPattern((PlayerEntity)player)) {
            if (mop.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return;
            }
            BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)mop;
            IToolMode mode = ChiselModeManager.getChiselMode((PlayerEntity)player, ChiselToolType.POSITIVEPATTERN, Hand.MAIN_HAND);
            BlockPos pos = rayTraceResult.func_216350_a();
            BlockPos partial = null;
            BlockState s = theWorld.func_180495_p(pos);
            if (!(s.func_177230_c() instanceof BlockChiseled) && !BlockBitInfo.canChisel(s)) {
                return;
            }
            if (!((ItemNegativePrint)ModItems.ITEM_NEGATIVE_PRINT.get()).isWritten(currentItem)) {
                return;
            }
            ItemStack item = ((ItemNegativePrint)ModItems.ITEM_NEGATIVE_PRINT.get()).getPatternedItem(currentItem, false);
            if (item == null || !item.func_77942_o()) {
                return;
            }
            int rotations = ModUtil.getRotations((LivingEntity)player, ModUtil.getSide(currentItem));
            if (mode == PositivePatternMode.PLACEMENT) {
                this.doGhostForChiseledBlock(event.getMatrixStack(), x, y, z, theWorld, (PlayerEntity)player, (BlockRayTraceResult)mop, item, item, rotations);
                return;
            }
            if (item != null && !item.func_190926_b()) {
                Object cacheRef;
                TileEntityBlockChiseled tebc = ModUtil.getChiseledTileEntity(theWorld, pos, false);
                Object object = cacheRef = tebc != null ? tebc : s;
                if (cacheRef instanceof TileEntityBlockChiseled) {
                    cacheRef = ((TileEntityBlockChiseled)cacheRef).getBlobStateReference();
                }
                RenderSystem.depthFunc((int)519);
                this.showGhost(event.getMatrixStack(), currentItem, item, rayTraceResult.func_216350_a(), (PlayerEntity)player, rotations, x, y, z, rayTraceResult.func_216354_b(), partial, cacheRef);
                RenderSystem.depthFunc((int)515);
            }
        } else if (ModUtil.isHoldingChiseledBlock((PlayerEntity)player)) {
            if (mop.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return;
            }
            ItemStack item = currentItem;
            if (!item.func_77942_o()) {
                return;
            }
            int rotations = ModUtil.getRotations((LivingEntity)player, ModUtil.getSide(item));
            this.doGhostForChiseledBlock(event.getMatrixStack(), x, y, z, theWorld, (PlayerEntity)player, (BlockRayTraceResult)mop, currentItem, item, rotations);
        }
    }

    private void doGhostForChiseledBlock(MatrixStack matrixStack, double x, double y, double z, World theWorld, PlayerEntity player, BlockRayTraceResult mop, ItemStack currentItem, ItemStack item, int rotations) {
        BlockPos offset = mop.func_216350_a();
        if (ClientSide.offGridPlacement(player)) {
            BitLocation bl = new BitLocation(mop, BitOperation.PLACE);
            this.showGhost(matrixStack, currentItem, item, bl.blockPos, player, rotations, x, y, z, mop.func_216354_b(), new BlockPos(bl.bitX, bl.bitY, bl.bitZ), null);
        } else {
            Hand hand;
            TileEntityBlockChiseled tebc;
            boolean canMerge = false;
            if (currentItem.func_77942_o() && (tebc = ModUtil.getChiseledTileEntity(theWorld, offset, true)) != null) {
                VoxelBlob blob = ModUtil.getBlobFromStack(currentItem, (LivingEntity)player);
                canMerge = tebc.canMerge(blob);
            }
            BlockPos newOffset = offset;
            Block block = theWorld.func_180495_p(newOffset).func_177230_c();
            Hand hand2 = hand = player.func_184600_cs() != null ? player.func_184600_cs() : Hand.MAIN_HAND;
            if (!(canMerge || ClientSide.offGridPlacement(player) || block.func_196253_a(theWorld.func_180495_p(newOffset), new BlockItemUseContext(player, hand, player.func_184586_b(hand), mop)))) {
                newOffset = offset.func_177972_a(mop.func_216354_b());
            }
            TileEntity newTarget = theWorld.func_175625_s(newOffset);
            if (theWorld.func_175623_d(newOffset) || newTarget instanceof TileEntityBlockChiseled || theWorld.func_175625_s(newOffset) instanceof TileEntityBlockChiseled && theWorld.func_180495_p(newOffset).func_177230_c().func_196253_a(theWorld.func_180495_p(newOffset), new BlockItemUseContext(player, hand, player.func_184586_b(hand), new BlockRayTraceResult(mop.func_216347_e().func_72441_c((double)mop.func_216354_b().func_82601_c(), (double)mop.func_216354_b().func_96559_d(), (double)mop.func_216354_b().func_82599_e()), mop.func_216354_b(), mop.func_216350_a().func_177971_a(mop.func_216354_b().func_176730_m()), mop.func_216353_d()))) || !(theWorld.func_175625_s(newOffset) instanceof TileEntityBlockChiseled) && theWorld.func_180495_p(newOffset).func_177230_c().func_196253_a(theWorld.func_180495_p(newOffset), new BlockItemUseContext(player, hand, player.func_184586_b(hand), mop))) {
                TileEntityBlockChiseled test = ModUtil.getChiseledTileEntity(theWorld, newOffset, false);
                this.showGhost(matrixStack, currentItem, item, newOffset, player, rotations, x, y, z, mop.func_216354_b(), null, test == null ? null : test.getBlobStateReference());
            }
        }
    }

    private void showGhost(MatrixStack matrixStack, ItemStack refItem, ItemStack item, BlockPos blockPos, PlayerEntity player, int rotationCount, double x, double y, double z, Direction side, BlockPos partial, Object cacheRef) {
        IBakedModel baked;
        block12: {
            VoxelBlob blob;
            NBTBlobConverter c;
            block13: {
                VoxelBlob pattern;
                block15: {
                    block14: {
                        block11: {
                            baked = null;
                            if (this.previousCacheRef != cacheRef || !this.samePos(this.lastPos, blockPos) || this.previousItem != refItem || this.previousRotations != rotationCount || this.previousModel == null || !this.samePos(this.lastPartial, partial)) break block11;
                            baked = (IBakedModel)this.previousModel;
                            break block12;
                        }
                        int rotations = rotationCount;
                        this.previousItem = refItem;
                        this.previousRotations = rotations;
                        this.previousCacheRef = cacheRef;
                        this.lastPos = blockPos;
                        this.lastPartial = partial;
                        c = new NBTBlobConverter();
                        c.readChisleData(ModUtil.getSubCompound(item, "BlockEntityTag", false), -1);
                        blob = c.getBlob();
                        while (rotations-- > 0) {
                            blob = blob.spin(Direction.Axis.Y);
                        }
                        this.modelBounds = blob.getBounds();
                        if (refItem.func_77973_b() != ModItems.ITEM_NEGATIVE_PRINT.get()) break block13;
                        pattern = blob;
                        if (!(cacheRef instanceof VoxelBlobStateReference)) break block14;
                        blob = ((VoxelBlobStateReference)cacheRef).getVoxelBlob();
                        break block15;
                    }
                    if (!(cacheRef instanceof BlockState)) break block13;
                    blob = new VoxelBlob();
                    blob.fill(ModUtil.getStateId((BlockState)cacheRef));
                }
                BitIterator it = new BitIterator();
                while (it.hasNext()) {
                    if (it.getNext(pattern) != 0) continue;
                    it.setNext(blob, 0);
                }
            }
            c.setBlob(blob);
            Block blk = Block.func_149634_a((Item)item.func_77973_b());
            ItemStack is = c.getItemStack(false);
            if (is == null || is.func_190926_b()) {
                this.isVisible = false;
            } else {
                baked = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(is);
                baked = baked.func_188617_f().func_239290_a_(baked, is, (ClientWorld)player.func_130014_f_(), (LivingEntity)player);
                this.previousModel = baked;
                if (refItem.func_77973_b() instanceof IPatternItem) {
                    this.isVisible = true;
                } else {
                    this.isVisible = true;
                    boolean bl = this.isUnplaceable = !ItemBlockChiseled.tryPlaceBlockAt(blk, item, player, player.func_130014_f_(), blockPos, side, Hand.MAIN_HAND, 0.5, 0.5, 0.5, partial, false);
                }
            }
        }
        if (!this.isVisible) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)blockPos.func_177958_n() - x, (double)blockPos.func_177956_o() - y - (double)player.func_70047_e(), (double)blockPos.func_177952_p() - z);
        if (partial != null) {
            BlockPos t = ModUtil.getPartialOffset(side, partial, this.modelBounds);
            double fullScale = 0.0625;
            matrixStack.func_227861_a_((double)t.func_177958_n() * 0.0625, (double)t.func_177956_o() * 0.0625, (double)t.func_177952_p() * 0.0625);
        }
        RenderHelper.renderGhostModel(matrixStack, baked, player.func_130014_f_(), blockPos, this.isUnplaceable, WorldRenderer.func_228421_a_((IBlockDisplayReader)player.func_130014_f_(), (BlockPos)blockPos), OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
    }

    private boolean samePos(BlockPos lastPartial2, BlockPos partial) {
        if (lastPartial2 == partial) {
            return true;
        }
        if (lastPartial2 == null || partial == null) {
            return false;
        }
        return partial.equals((Object)lastPartial2);
    }

    public PlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public boolean addHitEffects(World world, BlockRayTraceResult target, BlockState state, ParticleManager effectRenderer) {
        ItemStack hitWith = this.getPlayer().func_184614_ca();
        if (hitWith != null && (hitWith.func_77973_b() instanceof ItemChisel || hitWith.func_77973_b() instanceof ItemChiseledBit)) {
            return true;
        }
        BlockPos pos = target.func_216350_a();
        float boxOffset = 0.1f;
        AxisAlignedBB bb = world.func_180495_p(pos).func_177230_c().func_220053_a(state, (IBlockReader)world, pos, ISelectionContext.func_216377_a()).func_197752_a();
        double x = RANDOM.nextDouble() * (bb.field_72336_d - bb.field_72340_a - (double)0.2f) + (double)0.1f + bb.field_72340_a;
        double y = RANDOM.nextDouble() * (bb.field_72337_e - bb.field_72338_b - (double)0.2f) + (double)0.1f + bb.field_72338_b;
        double z = RANDOM.nextDouble() * (bb.field_72334_f - bb.field_72339_c - (double)0.2f) + (double)0.1f + bb.field_72339_c;
        switch (target.func_216354_b()) {
            case DOWN: {
                y = bb.field_72338_b - (double)0.1f;
                break;
            }
            case EAST: {
                x = bb.field_72336_d + (double)0.1f;
                break;
            }
            case NORTH: {
                z = bb.field_72339_c - (double)0.1f;
                break;
            }
            case SOUTH: {
                z = bb.field_72334_f + (double)0.1f;
                break;
            }
            case UP: {
                y = bb.field_72337_e + (double)0.1f;
                break;
            }
            case WEST: {
                x = bb.field_72340_a - (double)0.1f;
                break;
            }
        }
        effectRenderer.func_78873_a(new DiggingParticle((ClientWorld)world, x, y, z, 0.0, 0.0, 0.0, state).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SubscribeEvent
    public void wheelEvent(InputEvent.MouseScrollEvent me) {
        int dwheel = (int)me.getScrollDelta();
        if (me.isCanceled() || dwheel == 0) {
            return;
        }
        PlayerEntity player = instance.getPlayer();
        ItemStack is = player.func_184614_ca();
        if (dwheel != 0 && is != null && is.func_77973_b() instanceof IItemScrollWheel && player.func_225608_bj_()) {
            ((IItemScrollWheel)is.func_77973_b()).scroll(player, is, dwheel);
            me.setCanceled(true);
        }
    }

    public static void placeSound(World world, BlockPos pos, int stateID) {
        BlockState state = ModUtil.getStateById(stateID);
        Block block = state.func_177230_c();
        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, DeprecationHelper.getSoundType(block).func_185841_e(), SoundCategory.BLOCKS, (DeprecationHelper.getSoundType(block).func_185843_a() + 1.0f) / 16.0f, DeprecationHelper.getSoundType(block).func_185847_b() * 0.9f, false);
    }

    public static void breakSound(World world, BlockPos pos, int extractedState) {
        BlockState state = ModUtil.getStateById(extractedState);
        Block block = state.func_177230_c();
        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, DeprecationHelper.getSoundType(block).func_185845_c(), SoundCategory.BLOCKS, (DeprecationHelper.getSoundType(block).func_185843_a() + 1.0f) / 16.0f, DeprecationHelper.getSoundType(block).func_185847_b() * 0.9f, false);
    }

    public int getLastRenderedFrame() {
        return this.lastRenderedFrame;
    }

    public BitLocation getStartPos() {
        return this.drawStart;
    }

    public void pointAt(@Nonnull ChiselToolType type, @Nonnull BitLocation pos, @Nonnull Hand hand) {
        if (this.drawStart == null) {
            this.drawStart = pos;
            this.lastTool = type;
            this.lastHand = hand;
        }
    }

    public void setLastTool(@Nonnull ChiselToolType lastTool) {
        this.lastTool = lastTool;
    }

    KeyBinding getToolKey() {
        if (this.lastTool == ChiselToolType.CHISEL) {
            return Minecraft.func_71410_x().field_71474_y.field_74312_F;
        }
        return Minecraft.func_71410_x().field_71474_y.field_74313_G;
    }

    public boolean addBlockDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, BlockState state, ParticleManager effectRenderer) {
        if (!state.func_177230_c().isAir(state, (IBlockReader)world, pos)) {
            VoxelShape voxelshape = state.func_196954_c((IBlockReader)world, pos);
            double d0 = 0.25;
            voxelshape.func_197755_b((p_228348_3_, p_228348_5_, p_228348_7_, p_228348_9_, p_228348_11_, p_228348_13_) -> {
                double d1 = Math.min(1.0, p_228348_9_ - p_228348_3_);
                double d2 = Math.min(1.0, p_228348_11_ - p_228348_5_);
                double d3 = Math.min(1.0, p_228348_13_ - p_228348_7_);
                int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
                int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
                int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
                for (int l = 0; l < i; ++l) {
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d4 = ((double)l + 0.5) / (double)i;
                            double d5 = ((double)i1 + 0.5) / (double)j;
                            double d6 = ((double)j1 + 0.5) / (double)k;
                            double d7 = d4 * d1 + p_228348_3_;
                            double d8 = d5 * d2 + p_228348_5_;
                            double d9 = d6 * d3 + p_228348_7_;
                            effectRenderer.func_78873_a((Particle)new DiggingParticle((ClientWorld)world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                        }
                    }
                }
            });
        }
        return true;
    }

    public TextureAtlasSprite getMissingIcon() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation("missingno"));
    }

    public String getModeKey() {
        return this.getKeyName(this.modeMenu);
    }

    public ChiselToolType getDrawnTool() {
        return this.lastTool;
    }

    public boolean holdingShift() {
        return !Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_197986_j() && Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151470_d() || Screen.func_231173_s_();
    }

    public String getKeyName(KeyBinding bind) {
        if (bind == null) {
            return LocalStrings.noBind.getLocal();
        }
        if (bind.getKey().func_197937_c() == 0 && bind.func_197977_i().func_197937_c() != 0) {
            return DeprecationHelper.translateToLocal(bind.func_197982_m());
        }
        if (bind.getKey().func_197937_c() == 0) {
            return '\"' + DeprecationHelper.translateToLocal(bind.func_151464_g());
        }
        return this.makeMoreFrendly(bind.func_197982_m());
    }

    private String makeMoreFrendly(String displayName) {
        return DeprecationHelper.translateToLocal(displayName).replace("LMENU", LocalStrings.leftAlt.getLocal()).replace("RMENU", LocalStrings.rightAlt.getLocal()).replace("LSHIFT", LocalStrings.leftShift.getLocal()).replace("RSHIFT", LocalStrings.rightShift.getLocal()).replace("key.keyboard.", "");
    }

    public static boolean offGridPlacement(PlayerEntity player) {
        if (player instanceof FakePlayer) {
            return false;
        }
        if (player.func_130014_f_().field_72995_K) {
            return !ClientSide.getOffGridPlacementKey().func_197986_j() && ClientSide.getOffGridPlacementKey().func_151470_d();
        }
        throw new RuntimeException("checking keybinds on server.");
    }

    public static KeyBinding getOffGridPlacementKey() {
        if (!ClientSide.instance.offgridPlacement.func_197986_j() && ClientSide.instance.offgridPlacement.func_197985_l()) {
            return Minecraft.func_71410_x().field_71474_y.field_228046_af_;
        }
        return ClientSide.instance.offgridPlacement;
    }
}

