/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core;

import java.awt.image.BufferedImage;
import java.io.IOException;
import mod.chiselsandbits.bitbag.BagGui;
import mod.chiselsandbits.client.gui.SpriteIconPositioning;
import mod.chiselsandbits.client.model.loader.ChiseledBlockModelLoader;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.modes.PositivePatternMode;
import mod.chiselsandbits.modes.TapeMeasureModes;
import mod.chiselsandbits.printer.ChiselPrinterScreen;
import mod.chiselsandbits.registry.ModContainerTypes;
import mod.chiselsandbits.utils.TextureUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ChiselsAndBitsClient {
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientInit(FMLClientSetupEvent clientSetupEvent) {
        ClientSide.instance.preinit(ChiselsAndBits.getInstance());
        ClientSide.instance.init(ChiselsAndBits.getInstance());
        ClientSide.instance.postinit(ChiselsAndBits.getInstance());
        DeferredWorkQueue.runLater(() -> {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.BAG_CONTAINER.get()), BagGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CHISEL_STATION_CONTAINER.get()), ChiselPrinterScreen::new);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("chiselsandbits", "chiseled_block"), (IModelLoader)ChiseledBlockModelLoader.getInstance());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerIconTextures(TextureStitchEvent.Pre ev) {
        AtlasTexture map = ev.getMap();
        if (!map.func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        ev.addSprite(new ResourceLocation("chiselsandbits", "icons/swap"));
        ev.addSprite(new ResourceLocation("chiselsandbits", "icons/place"));
        ev.addSprite(new ResourceLocation("chiselsandbits", "icons/undo"));
        ev.addSprite(new ResourceLocation("chiselsandbits", "icons/redo"));
        ev.addSprite(new ResourceLocation("chiselsandbits", "icons/trash"));
        ev.addSprite(new ResourceLocation("chiselsandbits", "icons/sort"));
        ev.addSprite(new ResourceLocation("chiselsandbits", "icons/roll_x"));
        ev.addSprite(new ResourceLocation("chiselsandbits", "icons/roll_z"));
        ev.addSprite(new ResourceLocation("chiselsandbits", "icons/white"));
        for (ChiselMode chiselMode : ChiselMode.values()) {
            ev.addSprite(new ResourceLocation("chiselsandbits", "icons/" + chiselMode.name().toLowerCase()));
        }
        for (Enum enum_ : PositivePatternMode.values()) {
            ev.addSprite(new ResourceLocation("chiselsandbits", "icons/" + enum_.name().toLowerCase()));
        }
        for (Enum enum_ : TapeMeasureModes.values()) {
            ev.addSprite(new ResourceLocation("chiselsandbits", "icons/" + enum_.name().toLowerCase()));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void retrieveRegisteredIconSprites(TextureStitchEvent.Post ev) {
        AtlasTexture map = ev.getMap();
        if (!map.func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        ClientSide.swapIcon = map.func_195424_a(new ResourceLocation("chiselsandbits", "icons/swap"));
        ClientSide.placeIcon = map.func_195424_a(new ResourceLocation("chiselsandbits", "icons/place"));
        ClientSide.undoIcon = map.func_195424_a(new ResourceLocation("chiselsandbits", "icons/undo"));
        ClientSide.redoIcon = map.func_195424_a(new ResourceLocation("chiselsandbits", "icons/redo"));
        ClientSide.trashIcon = map.func_195424_a(new ResourceLocation("chiselsandbits", "icons/trash"));
        ClientSide.sortIcon = map.func_195424_a(new ResourceLocation("chiselsandbits", "icons/sort"));
        ClientSide.roll_x = map.func_195424_a(new ResourceLocation("chiselsandbits", "icons/roll_x"));
        ClientSide.roll_z = map.func_195424_a(new ResourceLocation("chiselsandbits", "icons/roll_z"));
        ClientSide.white = map.func_195424_a(new ResourceLocation("chiselsandbits", "icons/white"));
        for (ChiselMode chiselMode : ChiselMode.values()) {
            ChiselsAndBitsClient.loadIcon(map, chiselMode);
        }
        for (Enum enum_ : PositivePatternMode.values()) {
            ChiselsAndBitsClient.loadIcon(map, (IToolMode)((Object)enum_));
        }
        for (Enum enum_ : TapeMeasureModes.values()) {
            ChiselsAndBitsClient.loadIcon(map, (IToolMode)((Object)enum_));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void loadIcon(AtlasTexture map, IToolMode mode) {
        SpriteIconPositioning sip = new SpriteIconPositioning();
        ResourceLocation sprite = new ResourceLocation("chiselsandbits", "icons/" + mode.name().toLowerCase());
        ResourceLocation png = new ResourceLocation("chiselsandbits", "textures/icons/" + mode.name().toLowerCase() + ".png");
        sip.sprite = map.func_195424_a(sprite);
        try {
            IResource iresource = Minecraft.func_71410_x().func_195551_G().func_199002_a(png);
            BufferedImage bi = TextureUtils.readBufferedImage(iresource.func_199027_b());
            int bottom = 0;
            int right = 0;
            sip.left = bi.getWidth();
            sip.top = bi.getHeight();
            for (int x = 0; x < bi.getWidth(); ++x) {
                for (int y = 0; y < bi.getHeight(); ++y) {
                    int color = bi.getRGB(x, y);
                    int a = color >> 24 & 0xFF;
                    if (a <= 0) continue;
                    sip.left = Math.min(sip.left, (double)x);
                    right = Math.max(right, x);
                    sip.top = Math.min(sip.top, (double)y);
                    bottom = Math.max(bottom, y);
                }
            }
            sip.height = (double)bottom - sip.top + 1.0;
            sip.width = (double)right - sip.left + 1.0;
            sip.left /= (double)bi.getWidth();
            sip.width /= (double)bi.getWidth();
            sip.top /= (double)bi.getHeight();
            sip.height /= (double)bi.getHeight();
        }
        catch (IOException e) {
            sip.height = 1.0;
            sip.width = 1.0;
            sip.left = 0.0;
            sip.top = 0.0;
        }
        ClientSide.instance.setIconForMode(mode, sip);
    }
}

