/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitstorage;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Objects;
import mod.chiselsandbits.bitstorage.TileEntityBitStorage;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.render.chiseledblock.ChiselRenderType;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockBakedModel;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.utils.FluidCuboidHelper;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.FluidState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySpecialRenderBitStorage
extends TileEntityRenderer<TileEntityBitStorage> {
    private static final SimpleMaxSizedCache<CacheKey, VoxelBlob> STORAGE_CONTENTS_BLOB_CACHE = new SimpleMaxSizedCache((Long)ChiselsAndBits.getConfig().getClient().bitStorageContentCacheSize.get());

    public TileEntitySpecialRenderBitStorage(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntityBitStorage te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockState state;
        if (te.getMyFluid() != null) {
            FluidStack fluidStack = te.getBitsAsFluidStack();
            if (fluidStack != null) {
                RenderType.func_228661_n_().forEach(renderType -> {
                    if (!RenderTypeLookup.canRenderInLayer((FluidState)fluidStack.getFluid().func_207188_f(), (RenderType)renderType)) {
                        return;
                    }
                    if (renderType == RenderType.func_228645_f_() && Minecraft.func_238218_y_()) {
                        renderType = Atlases.func_228785_j_();
                    }
                    IVertexBuilder builder = buffer.getBuffer(renderType);
                    float fullness = (float)fluidStack.getAmount() / 4096.0f;
                    FluidCuboidHelper.renderScaledFluidCuboid(fluidStack, matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 15.0f, 15.0f * fullness, 15.0f);
                });
            }
            return;
        }
        int bits = te.getBits();
        BlockState blockState = state = te.getMyFluid() == null ? te.getState() : te.getMyFluid().func_207188_f().func_206883_i();
        if (bits <= 0 || state == null) {
            return;
        }
        VoxelBlob innerModelBlob = STORAGE_CONTENTS_BLOB_CACHE.get(new CacheKey(ModUtil.getStateId(state), bits));
        if (innerModelBlob == null) {
            innerModelBlob = new VoxelBlob();
            innerModelBlob.fillAmountFromBottom(ModUtil.getStateId(state), bits);
            STORAGE_CONTENTS_BLOB_CACHE.put(new CacheKey(ModUtil.getStateId(state), bits), innerModelBlob);
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.125, 0.125, 0.125);
        matrixStackIn.func_227862_a_(0.75f, 0.75f, 0.75f);
        VoxelBlob finalInnerModelBlob = innerModelBlob;
        RenderType.func_228661_n_().forEach(renderType -> {
            ChiseledBlockBakedModel innerModel = ChiseledBlockSmartModel.getCachedModel(ModUtil.getStateId(state), finalInnerModelBlob, ChiselRenderType.fromLayer(renderType, te.getMyFluid() != null), DefaultVertexFormats.field_176600_a, Objects.requireNonNull(te.func_145831_w()).func_201674_k());
            if (!innerModel.isEmpty()) {
                float r = te.getMyFluid() == null ? 1.0f : (float)(te.getMyFluid().getAttributes().getColor() >> 16 & 0xFF) / 255.0f;
                float g = te.getMyFluid() == null ? 1.0f : (float)(te.getMyFluid().getAttributes().getColor() >> 8 & 0xFF) / 255.0f;
                float b = te.getMyFluid() == null ? 1.0f : (float)(te.getMyFluid().getAttributes().getColor() & 0xFF) / 255.0f;
                Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModel(matrixStackIn.func_227866_c_(), buffer.getBuffer(renderType), state, (IBakedModel)innerModel, r, g, b, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
            }
        });
        matrixStackIn.func_227865_b_();
    }

    private static final class CacheKey {
        private final int blockStateId;
        private final int bitCount;

        private CacheKey(int blockStateId, int bitCount) {
            this.blockStateId = blockStateId;
            this.bitCount = bitCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.blockStateId == cacheKey.blockStateId && this.bitCount == cacheKey.bitCount;
        }

        public int hashCode() {
            return Objects.hash(this.blockStateId, this.bitCount);
        }
    }
}

