/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetcell;

import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellTile;
import java.util.Locale;
import net.minecraft.tileentity.TileEntityType;

public enum TargetCellType {
    BASIC,
    ADVANCED;


    public String getRegistryName() {
        return this.name().toLowerCase(Locale.ROOT) + "_target_cell";
    }

    public int getCapacity() {
        switch (this) {
            case BASIC: {
                return WormholeConfig.basicTargetCellCapacity.get();
            }
            case ADVANCED: {
                return WormholeConfig.advancedTargetCellCapacity.get();
            }
        }
        return 0;
    }

    public TargetCellTile createTile() {
        switch (this) {
            case BASIC: {
                return new TargetCellTile.BasicTargetCellTile();
            }
            case ADVANCED: {
                return new TargetCellTile.AdvancedTargetCellTile();
            }
        }
        return null;
    }

    public TargetCellBlock getBlock() {
        switch (this) {
            case BASIC: {
                return Wormhole.basic_target_cell;
            }
            case ADVANCED: {
                return Wormhole.advanced_target_cell;
            }
        }
        return null;
    }

    public TileEntityType<TargetCellTile> getTileEntityType() {
        switch (this) {
            case BASIC: {
                return Wormhole.basic_target_cell_tile;
            }
            case ADVANCED: {
                return Wormhole.advanced_target_cell_tile;
            }
        }
        return null;
    }
}

