/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetcell;

import com.supermartijn642.wormhole.portal.ITargetCellTile;
import com.supermartijn642.wormhole.portal.PortalGroupTile;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class TargetCellTile
extends PortalGroupTile
implements ITargetCellTile {
    public final TargetCellType field_200663_e;
    private final List<PortalTarget> targets = new ArrayList<PortalTarget>();

    public TargetCellTile(TargetCellType type) {
        super(type.getTileEntityType());
        this.field_200663_e = type;
        for (int i = 0; i < type.getCapacity(); ++i) {
            this.targets.add(null);
        }
    }

    @Override
    public int getTargetCapacity() {
        return this.field_200663_e.getCapacity();
    }

    @Override
    public PortalTarget getTarget(int index) {
        return this.targets.get(index);
    }

    @Override
    public void setTarget(int index, PortalTarget target) {
        this.targets.set(index, target);
        this.dataChanged();
    }

    @Override
    public List<PortalTarget> getTargets() {
        return this.targets;
    }

    @Override
    public int getNonNullTargetCount() {
        int count = 0;
        for (PortalTarget target : this.targets) {
            if (target == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected CompoundNBT writeData() {
        CompoundNBT tag = super.writeData();
        CompoundNBT targetsTag = new CompoundNBT();
        int count = 0;
        for (int i = 0; i < this.targets.size(); ++i) {
            targetsTag.func_74757_a("has" + i, this.targets.get(i) != null);
            if (this.targets.get(i) == null) continue;
            targetsTag.func_218657_a("target" + i, (INBT)this.targets.get(i).write());
            count = i + 1;
        }
        tag.func_74768_a("targetCount", count);
        tag.func_218657_a("targets", (INBT)targetsTag);
        return tag;
    }

    @Override
    protected void readData(CompoundNBT tag) {
        super.readData(tag);
        this.targets.clear();
        int count = tag.func_74764_b("targetCount") ? tag.func_74762_e("targetCount") : 0;
        CompoundNBT targetsTag = tag.func_74775_l("targets");
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            if (i < count && targetsTag.func_74764_b("has" + i) && targetsTag.func_74767_n("has" + i) && targetsTag.func_74764_b("target" + i)) {
                this.targets.add(new PortalTarget(targetsTag.func_74775_l("target" + i)));
                continue;
            }
            this.targets.add(null);
        }
    }

    public static class AdvancedTargetCellTile
    extends TargetCellTile {
        public AdvancedTargetCellTile() {
            super(TargetCellType.ADVANCED);
        }
    }

    public static class BasicTargetCellTile
    extends TargetCellTile {
        public BasicTargetCellTile() {
            super(TargetCellType.BASIC);
        }
    }
}

