/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.wormhole.ClientProxy;
import com.supermartijn642.wormhole.EnergyFormat;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.packets.PortalAddTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalClearTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalMoveTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalSelectTargetPacket;
import com.supermartijn642.wormhole.portal.screen.PortalGroupScreen;
import com.supermartijn642.wormhole.portal.screen.PortalTargetEditColorButton;
import com.supermartijn642.wormhole.portal.screen.ScreenBlockRenderer;
import com.supermartijn642.wormhole.screen.ArrowButton;
import com.supermartijn642.wormhole.screen.WormholeButton;
import com.supermartijn642.wormhole.screen.WormholeColoredButton;
import com.supermartijn642.wormhole.screen.WormholeLabel;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PortalTargetScreen
extends PortalGroupScreen {
    private static final ResourceLocation BACKGROUND = PortalTargetScreen.getTexture("select_target_screen/background");
    private static final ResourceLocation BACKGROUND_WITH_DEVICE = PortalTargetScreen.getTexture("select_target_screen/background_with_device");
    private static final ResourceLocation SELECT_HIGHLIGHT = PortalTargetScreen.getTexture("select_target_screen/select_highlight");
    private static final ResourceLocation SELECT_HIGHLIGHT_DEVICE = PortalTargetScreen.getTexture("select_target_screen/device_select_highlight");
    private static final ResourceLocation HOVER_HIGHLIGHT = PortalTargetScreen.getTexture("select_target_screen/hover_highlight");
    private static final ResourceLocation HOVER_HIGHLIGHT_DEVICE = PortalTargetScreen.getTexture("select_target_screen/device_hover_highlight");
    private static final ResourceLocation LOCATION_ICON = PortalTargetScreen.getTexture("select_target_screen/location_icon");
    private static final ResourceLocation ENERGY_ICON = PortalTargetScreen.getTexture("select_target_screen/lightning_icon");
    private static final ResourceLocation DIMENSION_ICON = PortalTargetScreen.getTexture("select_target_screen/dimension_icon");
    private static final ResourceLocation DIRECTION_ICON = PortalTargetScreen.getTexture("select_target_screen/direction_icon");
    private static final ResourceLocation STAR_ICON = PortalTargetScreen.getTexture("select_target_screen/star_icon");
    private static final ResourceLocation SEPARATOR = PortalTargetScreen.getTexture("select_target_screen/separator");
    private static final int WIDTH = 240;
    private static final int HEIGHT = 185;
    private static final int WIDTH_WITH_DEVICE = 353;
    private static final int HEIGHT_WITH_DEVICE = 185;
    private final PlayerEntity player;
    private final boolean hasTargetDevice;
    public final Hand hand;
    private int scrollOffset = 0;
    private int selectedPortalTarget;
    private int selectedDeviceTarget = -1;
    private final List<WormholeLabel> portalTargetNameLabels = new LinkedList<WormholeLabel>();
    private final List<ArrowButton> portalUpArrows = new LinkedList<ArrowButton>();
    private final List<ArrowButton> portalDownArrows = new LinkedList<ArrowButton>();
    private final List<WormholeLabel> deviceTargetNameLabels = new LinkedList<WormholeLabel>();
    private WormholeColoredButton selectButton;
    private WormholeColoredButton removeButton;
    private PortalTargetEditColorButton colorButton;

    private static ResourceLocation getTexture(String name) {
        return new ResourceLocation("wormhole", "textures/gui/" + name + ".png");
    }

    public PortalTargetScreen(BlockPos pos, PlayerEntity player) {
        super("wormhole.portal.targets.gui.title", pos);
        this.player = player;
        this.selectedPortalTarget = this.getFromPortalGroup(PortalGroup::getActiveTarget, null) == null ? -1 : this.getFromPortalGroup(PortalGroup::getActiveTargetIndex, -1);
        Hand hand = Hand.MAIN_HAND;
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        if (!(stack.func_77973_b() instanceof TargetDeviceItem)) {
            stack = player.func_184586_b(Hand.OFF_HAND);
            hand = Hand.OFF_HAND;
        }
        this.hasTargetDevice = stack.func_77973_b() instanceof TargetDeviceItem;
        this.hand = hand;
    }

    public PortalTargetScreen(BlockPos pos, PlayerEntity player, int scrollOffset, int selectedPortalTarget, int selectedDeviceTarget) {
        this(pos, player);
        this.scrollOffset = Math.min(scrollOffset, Math.max(0, this.getFromPortalGroup(PortalGroup::getTotalTargetCapacity, 0) - 10));
        this.selectedPortalTarget = selectedPortalTarget;
        this.selectedDeviceTarget = selectedDeviceTarget;
    }

    protected float sizeX(PortalGroup group) {
        return this.hasTargetDevice ? 353.0f : 240.0f;
    }

    protected float sizeY(PortalGroup group) {
        return this.hasTargetDevice ? 185.0f : 185.0f;
    }

    protected void addWidgets(PortalGroup group) {
        this.addPortalTargetWidgets();
        if (this.hasTargetDevice) {
            this.addDeviceTargetWidgets();
        }
        this.selectButton = (WormholeColoredButton)this.addWidget((Widget)new WormholeColoredButton(160, 146, 62, 11, "wormhole.portal.targets.gui.select", () -> Wormhole.CHANNEL.sendToServer((Object)new PortalSelectTargetPacket(this.getObject(), this.selectedPortalTarget))));
        this.removeButton = (WormholeColoredButton)this.addWidget((Widget)new WormholeColoredButton(160, 160, 62, 11, "wormhole.portal.targets.gui.remove", () -> {
            if (this.selectedPortalTarget >= 0) {
                Wormhole.CHANNEL.sendToServer((Object)new PortalClearTargetPacket(this.getObject(), this.selectedPortalTarget));
            } else if (this.selectedDeviceTarget >= 0) {
                Wormhole.CHANNEL.sendToServer((Object)new PortalAddTargetPacket(this.getObject(), this.hand, this.selectedDeviceTarget));
            }
        }));
        Supplier<DyeColor> color = () -> {
            PortalTarget target = this.getFromPortalGroup(group2 -> group2.getTarget(this.selectedPortalTarget), null);
            return target == null ? null : target.color;
        };
        this.colorButton = (PortalTargetEditColorButton)this.addWidget((Widget)new PortalTargetEditColorButton(this, 150, 91, () -> this.selectedPortalTarget, color, () -> ClientProxy.openPortalTargetScreen(this.pos, this.scrollOffset, this.selectedPortalTarget, this.selectedDeviceTarget)));
        this.addWidget((Widget)new WormholeButton(-35, 5, 30, 15, "wormhole.portal.targets.gui.return", () -> ClientProxy.openPortalOverviewScreen(this.pos)));
    }

    protected void render(MatrixStack matrixStack, int mouseX, int mouseY, PortalGroup group) {
        PortalTarget target;
        int targetIndex;
        ScreenUtils.bindTexture((ResourceLocation)(this.hasTargetDevice ? BACKGROUND_WITH_DEVICE : BACKGROUND));
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.sizeX(), (float)this.sizeY());
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (float)70.0f, (float)3.0f, (int)Integer.MAX_VALUE);
        if (this.hasTargetDevice) {
            ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"wormhole.target_device.gui.title", (Object[])new Object[0]), (float)296.0f, (float)3.0f, (int)Integer.MAX_VALUE);
        }
        GlStateManager.func_227709_e_();
        if (this.selectedPortalTarget >= this.scrollOffset && this.selectedPortalTarget < this.scrollOffset + 10) {
            ScreenUtils.bindTexture((ResourceLocation)SELECT_HIGHLIGHT);
            ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)5.0f, (float)(16 + 16 * (this.selectedPortalTarget - this.scrollOffset)), (float)130.0f, (float)16.0f);
        } else if (this.hasTargetDevice && this.selectedDeviceTarget >= 0 && this.selectedDeviceTarget < 10) {
            ScreenUtils.bindTexture((ResourceLocation)SELECT_HIGHLIGHT_DEVICE);
            ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)242.0f, (float)(16 + 16 * this.selectedDeviceTarget), (float)106.0f, (float)16.0f);
        }
        if (mouseX > 5 && mouseX < 135 && mouseY > 16 && mouseY < 176) {
            targetIndex = (mouseY - 16) / 16;
            if (group.getTarget(targetIndex + this.scrollOffset) != null) {
                ScreenUtils.bindTexture((ResourceLocation)HOVER_HIGHLIGHT);
                ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)5.0f, (float)(16 + targetIndex * 16), (float)130.0f, (float)16.0f);
            }
        } else if (this.hasTargetDevice && mouseX > 242 && mouseX < 348 && mouseY > 16 && mouseY < 176 && this.getFromDeviceTargets(arg_0 -> PortalTargetScreen.lambda$render$7(targetIndex = (mouseY - 16) / 16, arg_0), false).booleanValue()) {
            ScreenUtils.bindTexture((ResourceLocation)HOVER_HIGHLIGHT_DEVICE);
            ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)242.0f, (float)(16 + targetIndex * 16), (float)106.0f, (float)16.0f);
        }
        int activeTarget = this.getFromPortalGroup(PortalGroup::getActiveTargetIndex, -1);
        for (int count = 0; count < Math.min(10, this.portalTargetNameLabels.size()); ++count) {
            if (count + this.scrollOffset != activeTarget) {
                ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (String)(this.scrollOffset + count + 1 + "."), (float)14.0f, (float)(21 + count * 16));
                continue;
            }
            GlStateManager.func_227709_e_();
            ScreenUtils.bindTexture((ResourceLocation)STAR_ICON);
            ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)8.0f, (float)(19 + 16 * count), (float)10.0f, (float)10.0f);
        }
        if (this.selectedPortalTarget >= 0 && this.selectedPortalTarget < this.getFromPortalGroup(PortalGroup::getTotalTargetCapacity, 0)) {
            PortalTarget target2 = group.getTarget(this.selectedPortalTarget);
            if (target2 != null) {
                this.renderTargetInfo(matrixStack, target2, true);
            }
        } else if (this.hasTargetDevice && this.selectedDeviceTarget >= 0 && this.selectedDeviceTarget < 10 && (target = (PortalTarget)this.getFromDeviceTargets(list -> this.selectedDeviceTarget < list.size() ? (PortalTarget)list.get(this.selectedDeviceTarget) : null, null)) != null) {
            this.renderTargetInfo(matrixStack, target, false);
        }
        this.updateSelectRemoveColorButtons();
    }

    private void renderTargetInfo(MatrixStack matrixStack, PortalTarget target, boolean showColor) {
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)target.name, (float)191.0f, (float)31.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)SEPARATOR);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)153.0f, (float)41.0f, (float)77.0f, (float)1.0f);
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)LOCATION_ICON);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)150.0f, (float)47.0f, (float)9.0f, (float)9.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("(" + target.x + ", " + target.y + ", " + target.z + ")"), (float)161.0f, (float)48.0f, (int)Integer.MAX_VALUE);
        Block block = null;
        if (target.dimension.equals(World.field_234918_g_.func_240901_a_().toString())) {
            block = Blocks.field_185774_da;
        } else if (target.dimension.equals(World.field_234919_h_.func_240901_a_().toString())) {
            block = Blocks.field_150424_aL;
        } else if (target.dimension.equals(World.field_234920_i_.func_240901_a_().toString())) {
            block = Blocks.field_150377_bs;
        }
        if (block == null) {
            ScreenUtils.bindTexture((ResourceLocation)DIMENSION_ICON);
            ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)150.0f, (float)59.0f, (float)9.0f, (float)9.0f);
        } else {
            ScreenBlockRenderer.drawBlock(block, (double)this.left() + 154.5, (double)this.top() + 63.5, 5.5, 45.0f, 40.0f);
        }
        ScreenUtils.drawString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)target.getDimensionDisplayName(), (float)161.0f, (float)60.0f, (int)Integer.MAX_VALUE);
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)DIRECTION_ICON);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)148.0f, (float)69.0f, (float)13.0f, (float)13.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)("wormhole.direction." + Direction.func_176733_a((double)target.yaw).toString()), (Object[])new Object[0]), (float)161.0f, (float)72.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)SEPARATOR);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)153.0f, (float)85.0f, (float)77.0f, (float)1.0f);
        if (showColor) {
            ScreenUtils.drawString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)("wormhole.color." + (target.color == null ? "random" : target.color.func_176762_d())), (Object[])new Object[0]), (float)161.0f, (float)92.0f, (int)Integer.MAX_VALUE);
            ScreenUtils.bindTexture((ResourceLocation)SEPARATOR);
            ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)153.0f, (float)105.0f, (float)77.0f, (float)1.0f);
        }
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)ENERGY_ICON);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)150.0f, (float)(showColor ? 111.0f : 91.0f), (float)9.0f, (float)9.0f);
        int cost = PortalGroup.getTeleportCostToTarget(this.player.field_70170_p, this.getFromPortalGroup(PortalGroup::getCenterPos, BlockPos.field_177992_a), target);
        ScreenUtils.drawString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)EnergyFormat.formatEnergy(cost), (float)161.0f, (float)(showColor ? 112.0f : 92.0f), (int)Integer.MAX_VALUE);
    }

    private void addPortalTargetWidgets() {
        int portalCapacity = this.getFromPortalGroup(PortalGroup::getTotalTargetCapacity, 0);
        int count = 0;
        while (count < Math.min(10, portalCapacity)) {
            int index = count++;
            int y = 18 + index * 16;
            this.portalTargetNameLabels.add((WormholeLabel)this.addWidget(new WormholeLabel(20, y, 102, 12, () -> {
                PortalTarget target = this.getFromPortalGroup(group -> group.getTarget(index + this.scrollOffset), null);
                return target != null ? target.name : "";
            }, false)));
            ArrowButton upArrowButton = new ArrowButton(123, y + 1, true, () -> {
                if (this.selectedPortalTarget == this.scrollOffset + index) {
                    --this.selectedPortalTarget;
                } else if (this.selectedPortalTarget == this.scrollOffset + index - 1) {
                    ++this.selectedPortalTarget;
                }
                Wormhole.CHANNEL.sendToServer((Object)new PortalMoveTargetPacket(this.getObject(), this.scrollOffset + index, true));
            });
            this.portalUpArrows.add((ArrowButton)this.addWidget((Widget)upArrowButton));
            ArrowButton downArrowButton = new ArrowButton(123, y + 6, false, () -> {
                if (this.selectedPortalTarget == this.scrollOffset + index) {
                    ++this.selectedPortalTarget;
                } else if (this.selectedPortalTarget == this.scrollOffset + index + 1) {
                    --this.selectedPortalTarget;
                }
                Wormhole.CHANNEL.sendToServer((Object)new PortalMoveTargetPacket(this.getObject(), this.scrollOffset + index, false));
            });
            this.portalDownArrows.add((ArrowButton)this.addWidget((Widget)downArrowButton));
        }
        this.updateArrowButtons();
    }

    private void addDeviceTargetWidgets() {
        ItemStack stack = this.player.func_184586_b(this.hand);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof TargetDeviceItem)) {
            return;
        }
        int deviceCapacity = TargetDeviceItem.getMaxTargetCount(stack);
        int count = 0;
        while (count < Math.min(10, deviceCapacity)) {
            int index = count++;
            int y = 18 + index * 16;
            this.deviceTargetNameLabels.add((WormholeLabel)this.addWidget(new WormholeLabel(244, y, 102, 12, () -> {
                PortalTarget target = this.getFromDeviceTargets(list -> list.size() > index ? (PortalTarget)list.get(index) : null, null);
                return target != null ? target.name : "";
            }, false)));
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateArrowButtons();
    }

    private void updateArrowButtons() {
        int capacity = this.getFromPortalGroup(PortalGroup::getTotalTargetCapacity, 0);
        for (int i = 0; i < this.portalUpArrows.size() && i < this.portalDownArrows.size(); ++i) {
            int index = i + this.scrollOffset;
            boolean hasTarget = this.getFromPortalGroup(group -> group.getTarget(index) != null, false);
            this.portalUpArrows.get((int)i).active = index > 0 && hasTarget;
            this.portalDownArrows.get((int)i).active = index < capacity - 1 && hasTarget;
        }
    }

    private void updateSelectRemoveColorButtons() {
        if (this.selectedPortalTarget >= 0) {
            boolean notEmpty = this.getFromPortalGroup(group -> group.getTarget(this.selectedPortalTarget), null) != null;
            this.selectButton.setVisible();
            this.selectButton.setColorGreen();
            this.selectButton.setTextKey("wormhole.portal.targets.gui.select");
            this.selectButton.active = notEmpty && this.getFromPortalGroup(PortalGroup::getActiveTargetIndex, -1) != this.selectedPortalTarget;
            this.removeButton.setVisible();
            this.removeButton.setColorRed();
            this.removeButton.setTextKey("wormhole.portal.targets.gui.remove");
            this.removeButton.active = notEmpty;
            this.colorButton.visible = notEmpty;
        } else if (this.selectedDeviceTarget >= 0) {
            boolean notEmpty = this.getFromDeviceTargets(group -> group.size() > this.selectedDeviceTarget && group.get(this.selectedDeviceTarget) != null, false);
            this.selectButton.setInvisible();
            this.removeButton.setVisible();
            this.removeButton.setColorWhite();
            this.removeButton.setTextKey("wormhole.portal.targets.gui.add");
            this.removeButton.active = notEmpty;
            this.colorButton.visible = notEmpty;
        } else {
            this.selectButton.setInvisible();
            this.removeButton.setInvisible();
            this.colorButton.visible = false;
        }
    }

    protected void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY, PortalGroup group) {
        if (mouseX >= 149 && mouseX <= 160 && mouseY >= 46 && mouseY <= 57) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.target.location"), mouseX, mouseY);
        } else if (mouseX >= 149 && mouseX <= 160 && mouseY >= 58 && mouseY <= 69) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.target.dimension"), mouseX, mouseY);
        } else if (mouseX >= 149 && mouseX <= 160 && mouseY >= 70 && mouseY <= 81) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.target.direction"), mouseX, mouseY);
        } else if (mouseX >= 149 && mouseX <= 160 && (this.selectedPortalTarget >= 0 ? mouseY >= 110 && mouseY <= 121 : mouseY >= 90 && mouseY <= 101)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.target.teleport_cost"), mouseX, mouseY);
        }
    }

    public <T> T getFromDeviceTargets(Function<List<PortalTarget>, T> function, T other) {
        ItemStack stack = this.player.func_184586_b(this.hand);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof TargetDeviceItem) {
            return function.apply(TargetDeviceItem.getTargets(stack));
        }
        this.func_231175_as__();
        return other;
    }

    private void scroll(int amount) {
        this.scrollOffset = Math.min(Math.max(0, this.scrollOffset + amount), Math.max(0, this.getFromPortalGroup(PortalGroup::getTotalTargetCapacity, 0) - 10));
    }

    protected void onMouseScroll(int mouseX, int mouseY, double scroll) {
        if (mouseX >= 5 && mouseX <= 135 && mouseY >= 16 && mouseY <= 183) {
            this.scroll(-((int)scroll));
        }
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
        int targetIndex;
        if (button != 0) {
            return;
        }
        if (mouseX > 5 && mouseX < 135 && mouseY > 16 && mouseY < 176) {
            int targetIndex2 = (mouseY - 16) / 16 + this.scrollOffset;
            if (this.getFromPortalGroup(group -> group.getTarget(targetIndex2) != null, false).booleanValue()) {
                AbstractButtonWidget.playClickSound();
                this.selectedPortalTarget = targetIndex2;
                this.selectedDeviceTarget = -1;
            }
        } else if (this.hasTargetDevice && mouseX > 242 && mouseX < 348 && mouseY > 16 && mouseY < 176 && this.getFromDeviceTargets(arg_0 -> PortalTargetScreen.lambda$onMousePress$19(targetIndex = (mouseY - 16) / 16, arg_0), false).booleanValue()) {
            AbstractButtonWidget.playClickSound();
            this.selectedPortalTarget = -1;
            this.selectedDeviceTarget = targetIndex;
        }
    }

    private static /* synthetic */ Boolean lambda$onMousePress$19(int targetIndex, List list) {
        return list.size() > targetIndex && list.get(targetIndex) != null;
    }

    private static /* synthetic */ Boolean lambda$render$7(int targetIndex, List list) {
        return list.size() > targetIndex && list.get(targetIndex) != null;
    }
}

