/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.wormhole.ClientProxy;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellTile;
import com.supermartijn642.wormhole.energycell.EnergyCellTileRenderer;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellTile;
import com.supermartijn642.wormhole.targetcell.TargetCellTileRenderer;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class PortalRendererHelper {
    private static final int ROTATE_TIME = 20000;

    public static void drawPortal(PortalShape shape, float x, float y, float width, float height) {
        World world = ClientProxy.getWorld();
        double scale = (double)Math.min(width, height) / (shape.span + 1.0);
        Vector3f center = new Vector3f((float)(shape.maxCorner.func_177958_n() + shape.minCorner.func_177958_n()) / 2.0f, (float)(shape.maxCorner.func_177956_o() + shape.minCorner.func_177956_o()) / 2.0f, (float)(shape.maxCorner.func_177952_p() + shape.minCorner.func_177952_p()) / 2.0f);
        RenderSystem.pushMatrix();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.translatef((float)(x + width / 2.0f), (float)(y + height / 2.0f), (float)350.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderHelper.func_227783_c_();
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227863_a_(new Quaternion(45.0f, (float)(System.currentTimeMillis() % 20000L) / 20000.0f * 360.0f, 0.0f, true));
        matrixstack.func_227861_a_((double)(-center.func_195899_a()), (double)(-center.func_195900_b()), (double)(-center.func_195902_c()));
        for (BlockPos pos : shape.frame) {
            PortalRendererHelper.renderBlock(world, pos, matrixstack, (IRenderTypeBuffer)renderTypeBuffer, true);
        }
        for (BlockPos pos : shape.area) {
            if (world.func_175623_d(pos)) continue;
            PortalRendererHelper.renderBlock(world, pos, matrixstack, (IRenderTypeBuffer)renderTypeBuffer, world.func_180495_p(pos).func_177230_c() instanceof PortalBlock);
            PortalRendererHelper.renderTileEntity(world, pos, matrixstack, (IRenderTypeBuffer)renderTypeBuffer);
        }
        renderTypeBuffer.func_228461_a_();
        RenderSystem.enableDepthTest();
        RenderHelper.func_227784_d_();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    private static void renderBlock(World world, BlockPos pos, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, boolean valid) {
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof EnergyCellBlock) && !(state.func_177230_c() instanceof TargetCellBlock) && state.func_185901_i() != BlockRenderType.MODEL) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        IBakedModel model = tile instanceof TargetCellTile ? TargetCellTileRenderer.getModelForTile((TargetCellTile)tile) : (tile instanceof EnergyCellTile ? EnergyCellTileRenderer.getModelForTile((EnergyCellTile)tile) : Minecraft.func_71410_x().func_175602_ab().func_184389_a(state));
        EmptyModelData modelData = tile == null ? EmptyModelData.INSTANCE : tile.getModelData();
        modelData = model.getModelData((IBlockDisplayReader)world, pos, state, (IModelData)modelData);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        PortalRendererHelper.translateAndRenderModel(state, matrixStack, renderTypeBuffer, 0xF000F0, OverlayTexture.field_229196_a_, model, (IModelData)modelData, valid);
        matrixStack.func_227865_b_();
    }

    private static void translateAndRenderModel(BlockState state, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn, IModelData modelData, boolean valid) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
        RenderType rendertype = RenderType.func_228645_f_();
        PortalRendererHelper.renderModel(modelIn, state, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn.getBuffer(rendertype), modelData, valid);
        matrixStackIn.func_227865_b_();
    }

    private static void renderModel(IBakedModel modelIn, BlockState state, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IVertexBuilder bufferIn, IModelData modelData, boolean valid) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            PortalRendererHelper.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, direction, random, modelData), combinedLightIn, combinedOverlayIn, valid);
        }
        random.setSeed(42L);
        PortalRendererHelper.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, null, random, modelData), combinedLightIn, combinedOverlayIn, valid);
    }

    private static void renderQuads(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, int combinedLightIn, int combinedOverlayIn, boolean valid) {
        MatrixStack.Entry matrix = matrixStackIn.func_227866_c_();
        for (BakedQuad bakedquad : quadsIn) {
            bufferIn.addVertexData(matrix, bakedquad, 1.0f, valid ? 1.0f : 0.5f, valid ? 1.0f : 0.5f, valid ? 1.0f : 0.8f, combinedLightIn, combinedOverlayIn, false);
        }
    }

    private static void renderTileEntity(World world, BlockPos pos, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer) {
        TileEntityRenderer tileRenderer;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && (tileRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile)) != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)pos.func_177958_n() - 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() - 0.5);
            tileRenderer.func_225616_a_(tile, Minecraft.func_71410_x().func_184121_ak(), matrixStack, renderTypeBuffer, 0xF000F0, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
    }
}

