/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.TeleportHelper;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.IEnergyCellTile;
import com.supermartijn642.wormhole.portal.ITargetCellTile;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;

public class PortalGroup {
    public final PortalShape shape;
    public final World world;
    public boolean canTick = false;
    private int activeTarget = 0;
    private boolean activated;

    public PortalGroup(World world, PortalShape shape) {
        this.world = world;
        this.shape = shape;
    }

    public PortalGroup(World world, CompoundNBT tag) {
        this.world = world;
        this.shape = PortalShape.read(tag.func_74775_l("shape"));
        this.activeTarget = tag.func_74764_b("activeTarget") ? tag.func_74762_e("activeTarget") : 0;
        this.activated = tag.func_74764_b("activated") && tag.func_74767_n("activated");
    }

    public void tick() {
        if (!this.canTick) {
            return;
        }
        this.canTick = false;
        if (this.activated && WormholeConfig.requirePower.get().booleanValue()) {
            if (this.getStoredEnergy() < this.getIdleEnergyCost()) {
                this.deactivate();
            } else {
                this.drainEnergy(this.getIdleEnergyCost());
            }
        }
    }

    public void setTarget(int index, PortalTarget target) {
        int total = 0;
        for (BlockPos pos : this.shape.targetCells) {
            TileEntity tile = this.world.func_175625_s(pos);
            if (!(tile instanceof ITargetCellTile)) continue;
            int capacity = ((ITargetCellTile)tile).getTargetCapacity();
            if (total + capacity > index) {
                ((ITargetCellTile)tile).setTarget(index - total, target);
                break;
            }
            total += capacity;
        }
        if (this.activated && index == this.activeTarget) {
            if (target == null) {
                this.deactivate();
            } else {
                this.shape.createPortals(this.world, target.color);
            }
        }
    }

    public void clearTarget(int index) {
        this.setTarget(index, null);
    }

    public void moveTarget(int index, boolean up) {
        if (up ? index == 0 : index == this.getTotalTargetCapacity() - 1) {
            return;
        }
        int lowIndex = up ? index - 1 : index;
        int highIndex = up ? index : index + 1;
        ITargetCellTile lowTile = null;
        int lowTileIndex = 0;
        ITargetCellTile highTile = null;
        int highTileIndex = 0;
        int total = 0;
        for (BlockPos pos : this.shape.targetCells) {
            TileEntity tile = this.world.func_175625_s(pos);
            if (!(tile instanceof ITargetCellTile)) continue;
            int capacity = ((ITargetCellTile)tile).getTargetCapacity();
            if (lowTile == null && total + capacity > lowIndex) {
                lowTile = (ITargetCellTile)tile;
                lowTileIndex = lowIndex - total;
            }
            if (highTile == null && total + capacity > highIndex) {
                highTile = (ITargetCellTile)tile;
                highTileIndex = highIndex - total;
            }
            total += capacity;
        }
        if (lowTile == null || highTile == null) {
            return;
        }
        PortalTarget lowTarget = lowTile.getTarget(lowTileIndex);
        lowTile.setTarget(lowTileIndex, highTile.getTarget(highTileIndex));
        highTile.setTarget(highTileIndex, lowTarget);
        if (lowIndex == this.activeTarget) {
            ++this.activeTarget;
            this.updateGroup();
        } else if (highIndex == this.activeTarget) {
            --this.activeTarget;
            this.updateGroup();
        }
    }

    public void setActiveTarget(int index) {
        if (index != this.activeTarget) {
            this.activeTarget = index;
            if (this.activated) {
                PortalTarget target = this.getActiveTarget();
                if (target == null) {
                    this.deactivate();
                } else {
                    this.shape.createPortals(this.world, this.getActiveTarget().color);
                }
            }
            this.updateGroup();
        }
    }

    public PortalTarget getActiveTarget() {
        return this.getTarget(this.activeTarget);
    }

    public int getActiveTargetIndex() {
        return this.activeTarget;
    }

    public int getTotalTargetCapacity() {
        int total = 0;
        for (BlockPos pos : this.shape.targetCells) {
            TileEntity tile = this.world.func_175625_s(pos);
            if (!(tile instanceof ITargetCellTile)) continue;
            total += ((ITargetCellTile)tile).getTargetCapacity();
        }
        return total;
    }

    public PortalTarget getTarget(int index) {
        if (index < 0) {
            return null;
        }
        int total = 0;
        for (BlockPos pos : this.shape.targetCells) {
            TileEntity tile = this.world.func_175625_s(pos);
            if (!(tile instanceof ITargetCellTile)) continue;
            int capacity = ((ITargetCellTile)tile).getTargetCapacity();
            if (total + capacity > index) {
                return ((ITargetCellTile)tile).getTarget(index - total);
            }
            total += capacity;
        }
        return null;
    }

    public boolean hasTargetSpaceLeft() {
        for (int i = 0; i < this.getTotalTargetCapacity(); ++i) {
            if (this.getTarget(i) != null) continue;
            return true;
        }
        return false;
    }

    public void addTarget(PortalTarget target) {
        for (int i = 0; i < this.getTotalTargetCapacity(); ++i) {
            if (this.getTarget(i) != null) continue;
            this.setTarget(i, target);
            return;
        }
    }

    public int getEnergyCapacity() {
        int total = 0;
        for (BlockPos pos : this.shape.energyCells) {
            TileEntity tile = this.world.func_175625_s(pos);
            if (!(tile instanceof IEnergyStorage)) continue;
            total += ((IEnergyCellTile)tile).getMaxEnergyStored(true);
        }
        return total;
    }

    public int getStoredEnergy() {
        int total = 0;
        for (BlockPos pos : this.shape.energyCells) {
            TileEntity tile = this.world.func_175625_s(pos);
            if (!(tile instanceof IEnergyStorage)) continue;
            total += ((IEnergyCellTile)tile).getEnergyStored(true);
        }
        return total;
    }

    public void drainEnergy(int energy) {
        for (BlockPos pos : this.shape.energyCells) {
            TileEntity tile = this.world.func_175625_s(pos);
            if (!(tile instanceof IEnergyStorage)) continue;
            energy -= ((IEnergyCellTile)tile).extractEnergy(energy, false, true);
        }
    }

    public int receiveEnergy(int energy, boolean simulate) {
        BlockPos pos;
        TileEntity tile;
        int received = 0;
        Iterator<BlockPos> iterator = this.shape.energyCells.iterator();
        while (iterator.hasNext() && (!((tile = this.world.func_175625_s(pos = iterator.next())) instanceof IEnergyStorage) || (received += ((IEnergyCellTile)tile).receiveEnergy(energy - received, simulate, true)) < energy)) {
        }
        return received;
    }

    public void activate() {
        if (!(this.activated || this.getActiveTarget() == null || !this.shape.validatePortal((IBlockReader)this.world) || WormholeConfig.requirePower.get().booleanValue() && this.getStoredEnergy() < this.getIdleEnergyCost())) {
            this.shape.createPortals(this.world, this.getActiveTarget().color);
            this.activated = true;
            this.updateGroup();
        }
    }

    public void deactivate() {
        if (this.activated) {
            this.shape.destroyPortals(this.world);
            this.activated = false;
            this.updateGroup();
        }
    }

    public boolean isActive() {
        return this.activated;
    }

    public void teleport(Entity entity) {
        PortalTarget target = this.getActiveTarget();
        if (!this.activated || target == null || !TeleportHelper.canTeleport(entity, target)) {
            return;
        }
        if (WormholeConfig.requirePower.get().booleanValue()) {
            int cost;
            int energy = this.getStoredEnergy();
            if (energy < (cost = this.getTeleportEnergyCost())) {
                this.drainEnergy(energy);
                return;
            }
            this.drainEnergy(cost);
        }
        TeleportHelper.queTeleport(entity, target);
    }

    public int getTeleportEnergyCost() {
        PortalTarget target = this.getActiveTarget();
        if (target == null) {
            return 0;
        }
        return PortalGroup.getTeleportCostToTarget(this.world, this.getCenterPos(), target);
    }

    public int getIdleEnergyCost() {
        return WormholeConfig.idlePowerDrain.get() + (int)Math.round((double)this.shape.area.size() * WormholeConfig.sizePowerDrain.get());
    }

    public void destroy() {
        this.deactivate();
        this.world.getCapability(PortalGroupCapability.CAPABILITY).ifPresent(groups -> groups.remove(this));
    }

    public CompoundNBT write() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("shape", (INBT)this.shape.write());
        tag.func_74768_a("activeTarget", this.activeTarget);
        tag.func_74757_a("activated", this.activated);
        return tag;
    }

    private void updateGroup() {
        this.world.getCapability(PortalGroupCapability.CAPABILITY).ifPresent(groups -> groups.updateGroup(this));
    }

    public BlockPos getCenterPos() {
        return new BlockPos((this.shape.minCorner.func_177958_n() + this.shape.maxCorner.func_177958_n()) / 2, (this.shape.minCorner.func_177956_o() + this.shape.maxCorner.func_177956_o()) / 2, (this.shape.minCorner.func_177952_p() + this.shape.maxCorner.func_177952_p()) / 2);
    }

    public static int getTeleportCostToTarget(World world, BlockPos portalCenter, PortalTarget target) {
        return WormholeConfig.travelPowerDrain.get() + (target.dimension.equals(world.func_234923_W_().func_240901_a_().toString()) ? (int)Math.round(Math.pow(portalCenter.func_177951_i((Vector3i)target.getPos()), 0.25) * WormholeConfig.distancePowerDrain.get()) : WormholeConfig.dimensionPowerDrain.get());
    }
}

