/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.packet;

import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.portal.PortalGroup;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class PortalGroupPacket {
    protected BlockPos pos;

    public PortalGroupPacket(PortalGroup group) {
        this.pos = group.shape.frame.get(0);
    }

    public PortalGroupPacket(PacketBuffer buffer) {
        this.decode(buffer);
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
    }

    protected void decode(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().setPacketHandled(true);
        ServerPlayerEntity player = contextSupplier.get().getSender();
        if (player == null || player.func_213303_ch().func_186679_c((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()) > 10000.0) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        PortalGroupCapability groups = (PortalGroupCapability)world.getCapability(PortalGroupCapability.CAPABILITY).orElse(null);
        if (groups == null) {
            return;
        }
        PortalGroup group = groups.getGroup(this.pos);
        if (group == null) {
            return;
        }
        contextSupplier.get().enqueueWork(() -> this.lambda$handle$0((PlayerEntity)player, world, group));
    }

    protected abstract void handle(PlayerEntity var1, World var2, PortalGroup var3);

    private /* synthetic */ void lambda$handle$0(PlayerEntity player, World world, PortalGroup group) {
        this.handle(player, world, group);
    }
}

