/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.ClientProxy;
import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.StabilizerBlock;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.IEnergyCellTile;
import com.supermartijn642.wormhole.portal.ITargetCellTile;
import com.supermartijn642.wormhole.portal.PortalGroupTile;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class StabilizerTile
extends PortalGroupTile
implements ITargetCellTile,
IEnergyCellTile {
    private final List<PortalTarget> targets = new ArrayList<PortalTarget>();
    private int energy = 0;

    public StabilizerTile() {
        super(Wormhole.stabilizer_tile);
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            this.targets.add(null);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_195044_w().func_177230_c() instanceof StabilizerBlock && this.hasGroup() != ((Boolean)this.func_195044_w().func_177229_b((Property)StabilizerBlock.ON_PROPERTY)).booleanValue()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)Wormhole.portal_stabilizer.func_176223_P().func_206870_a((Property)StabilizerBlock.ON_PROPERTY, (Comparable)Boolean.valueOf(this.hasGroup())), 2);
        }
    }

    public boolean activate(PlayerEntity player) {
        if (this.hasGroup()) {
            ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
            if (!(stack.func_77973_b() instanceof TargetDeviceItem)) {
                stack = player.func_184586_b(Hand.OFF_HAND);
            }
            if (stack.func_77973_b() instanceof TargetDeviceItem) {
                if (this.field_145850_b.field_72995_K) {
                    ClientProxy.openPortalTargetScreen(this.field_174879_c);
                }
            } else if (this.field_145850_b.field_72995_K) {
                ClientProxy.openPortalOverviewScreen(this.field_174879_c);
            }
        } else if (!this.field_145850_b.field_72995_K) {
            PortalShape shape = PortalShape.find((IBlockReader)this.field_145850_b, this.field_174879_c);
            if (shape == null) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("wormhole.portal_stabilizer.error").func_240699_a_(TextFormatting.RED), player.func_110124_au());
            } else {
                this.field_145850_b.getCapability(PortalGroupCapability.CAPABILITY).ifPresent(groups -> groups.add(shape));
                player.func_145747_a((ITextComponent)new TranslationTextComponent("wormhole.portal_stabilizer.success").func_240699_a_(TextFormatting.YELLOW), player.func_110124_au());
            }
        }
        return true;
    }

    @Override
    public int getTargetCapacity() {
        return WormholeConfig.stabilizerTargetCapacity.get();
    }

    @Override
    public PortalTarget getTarget(int index) {
        return this.targets.get(index);
    }

    @Override
    public void setTarget(int index, PortalTarget target) {
        this.targets.set(index, target);
        this.dataChanged();
    }

    @Override
    public List<PortalTarget> getTargets() {
        return this.targets;
    }

    @Override
    public int getNonNullTargetCount() {
        int count = 0;
        for (PortalTarget target : this.targets) {
            if (target == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate, boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().receiveEnergy(maxReceive, simulate);
        }
        if (maxReceive < 0) {
            return -this.extractEnergy(-maxReceive, simulate);
        }
        int absorb = Math.min(this.getMaxEnergyStored(true) - this.energy, maxReceive);
        if (!simulate) {
            this.energy += absorb;
            if (absorb > 0) {
                this.dataChanged();
            }
        }
        return absorb;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate, boolean fromGroup) {
        if (maxExtract < 0) {
            return -this.receiveEnergy(-maxExtract, simulate);
        }
        int drain = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= drain;
            if (drain > 0) {
                this.dataChanged();
            }
        }
        return drain;
    }

    @Override
    public int getEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getStoredEnergy();
        }
        return Math.min(this.energy, this.getMaxEnergyStored(true));
    }

    @Override
    public int getMaxEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getEnergyCapacity();
        }
        return WormholeConfig.stabilizerEnergyCapacity.get();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected CompoundNBT writeData() {
        CompoundNBT tag = super.writeData();
        CompoundNBT targetsTag = new CompoundNBT();
        int count = 0;
        for (int i = 0; i < this.targets.size(); ++i) {
            targetsTag.func_74757_a("has" + i, this.targets.get(i) != null);
            if (this.targets.get(i) == null) continue;
            targetsTag.func_218657_a("target" + i, (INBT)this.targets.get(i).write());
            count = i + 1;
        }
        tag.func_74768_a("targetCount", count);
        tag.func_218657_a("targets", (INBT)targetsTag);
        tag.func_74768_a("energy", this.energy);
        return tag;
    }

    @Override
    protected void readData(CompoundNBT tag) {
        CompoundNBT groupTag;
        super.readData(tag);
        this.targets.clear();
        int count = tag.func_74764_b("targetCount") ? tag.func_74762_e("targetCount") : 0;
        CompoundNBT targetsTag = tag.func_74775_l("targets");
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            if (i < count && targetsTag.func_74764_b("has" + i) && targetsTag.func_74767_n("has" + i) && targetsTag.func_74764_b("target" + i)) {
                this.targets.add(new PortalTarget(targetsTag.func_74775_l("target" + i)));
                continue;
            }
            this.targets.add(null);
        }
        int n = this.energy = tag.func_74764_b("energy") ? tag.func_74762_e("energy") : 0;
        if (tag.func_74764_b("group") && (groupTag = new CompoundNBT()).func_74764_b("target")) {
            this.targets.set(0, PortalTarget.read(groupTag.func_74775_l("target")));
        }
    }
}

