/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.EnergyFormat;
import com.supermartijn642.wormhole.StabilizerTile;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class StabilizerBlock
extends PortalGroupBlock {
    public static final BooleanProperty ON_PROPERTY = BooleanProperty.func_177716_a((String)"on");

    public StabilizerBlock() {
        super("portal_stabilizer", StabilizerTile::new);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)ON_PROPERTY, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof StabilizerTile) {
            return ((StabilizerTile)tile).activate(player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ON_PROPERTY});
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("wormhole.portal_stabilizer.info").func_240699_a_(TextFormatting.AQUA));
        CompoundNBT tag = stack.func_196082_o().func_74764_b("tileData") ? stack.func_196082_o().func_74775_l("tileData") : null;
        int targets = tag == null || tag.isEmpty() || !tag.func_74764_b("targetCount") ? 0 : tag.func_74762_e("targetCount");
        int targetCapacity = WormholeConfig.stabilizerTargetCapacity.get();
        if (targetCapacity > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("wormhole.portal_stabilizer.info.targets", new Object[]{targets, targetCapacity}).func_240699_a_(TextFormatting.YELLOW));
        }
        int energy = tag == null || tag.isEmpty() || !tag.func_74764_b("energy") ? 0 : tag.func_74762_e("energy");
        int energyCapacity = WormholeConfig.stabilizerEnergyCapacity.get();
        if (energyCapacity > 0) {
            tooltip.add((ITextComponent)new StringTextComponent(EnergyFormat.formatCapacity(energy, energyCapacity)).func_240699_a_(TextFormatting.YELLOW));
        }
    }
}

