/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.packet.UpdateGroupPacket;
import com.supermartijn642.wormhole.packet.UpdateGroupsPacket;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalGroupTile;
import com.supermartijn642.wormhole.portal.PortalShape;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PortalGroupCapability {
    @CapabilityInject(value=PortalGroupCapability.class)
    public static Capability<PortalGroupCapability> CAPABILITY;
    private final World world;
    private final List<PortalGroup> groups = new LinkedList<PortalGroup>();
    private final Map<BlockPos, PortalGroup> groupsByPosition = new HashMap<BlockPos, PortalGroup>();

    public static void register() {
        CapabilityManager.INSTANCE.register(PortalGroupCapability.class, (Capability.IStorage)new Capability.IStorage<PortalGroupCapability>(){

            public CompoundNBT writeNBT(Capability<PortalGroupCapability> capability, PortalGroupCapability instance, Direction side) {
                return instance.write();
            }

            public void readNBT(Capability<PortalGroupCapability> capability, PortalGroupCapability instance, Direction side, INBT nbt) {
                instance.read((CompoundNBT)nbt);
            }
        }, PortalGroupCapability::new);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<World> e) {
        World world = (World)e.getObject();
        final LazyOptional capability = LazyOptional.of(() -> new PortalGroupCapability(world));
        e.addCapability(new ResourceLocation("wormhole", "portal_groups"), (ICapabilityProvider)new ICapabilitySerializable<INBT>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CAPABILITY ? capability.cast() : LazyOptional.empty();
            }

            public INBT serializeNBT() {
                return CAPABILITY.writeNBT(capability.orElse(null), null);
            }

            public void deserializeNBT(INBT nbt) {
                CAPABILITY.readNBT(capability.orElse(null), null, nbt);
            }
        });
        e.addListener(() -> ((LazyOptional)capability).invalidate());
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        PortalGroupCapability.tickWorldCapability(e.world);
    }

    public static void tickWorldCapability(World world) {
        world.getCapability(CAPABILITY).ifPresent(PortalGroupCapability::tick);
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerChangedDimensionEvent e) {
        ServerPlayerEntity player = (ServerPlayerEntity)e.getPlayer();
        player.field_70170_p.getCapability(CAPABILITY).ifPresent(groups -> Wormhole.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateGroupsPacket(groups.write())));
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        ServerPlayerEntity player = (ServerPlayerEntity)e.getPlayer();
        player.field_70170_p.getCapability(CAPABILITY).ifPresent(groups -> Wormhole.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateGroupsPacket(groups.write())));
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        ServerPlayerEntity player = (ServerPlayerEntity)e.getPlayer();
        player.field_70170_p.getCapability(CAPABILITY).ifPresent(groups -> Wormhole.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateGroupsPacket(groups.write())));
    }

    public PortalGroupCapability(World world) {
        this.world = world;
    }

    public PortalGroupCapability() {
        this.world = null;
    }

    public void add(PortalShape shape) {
        PortalGroup group = new PortalGroup(this.world, shape);
        this.groups.add(group);
        group.shape.frame.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
        group.shape.area.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
        this.update();
    }

    public void remove(PortalGroup group) {
        this.groups.remove(group);
        group.shape.frame.forEach(this.groupsByPosition::remove);
        group.shape.area.forEach(this.groupsByPosition::remove);
        this.update();
    }

    public void tick() {
        for (PortalGroup group : this.groupsByPosition.values()) {
            group.canTick = true;
        }
    }

    public void updateGroup(PortalGroup group) {
        if (!this.world.field_72995_K && group != null) {
            Wormhole.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((World)this.world).func_234923_W_()), (Object)new UpdateGroupPacket(this.writeGroup(group)));
        }
    }

    private void update() {
        Wormhole.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((World)this.world).func_234923_W_()), (Object)new UpdateGroupsPacket(this.write()));
    }

    public PortalGroup getGroup(PortalGroupTile tile) {
        return this.groupsByPosition.get(tile.func_174877_v());
    }

    public PortalGroup getGroup(BlockPos pos) {
        return this.groupsByPosition.get(pos);
    }

    public Collection<PortalGroup> getGroups() {
        return this.groupsByPosition.values();
    }

    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT groupsTag = new CompoundNBT();
        for (int i = 0; i < this.groups.size(); ++i) {
            groupsTag.func_218657_a("groups" + i, (INBT)this.groups.get(i).write());
        }
        compound.func_218657_a("groups", (INBT)groupsTag);
        return compound;
    }

    public void read(CompoundNBT compound) {
        this.groups.clear();
        this.groupsByPosition.clear();
        CompoundNBT groupsTag = compound.func_74775_l("groups");
        for (String key : groupsTag.func_150296_c()) {
            PortalGroup group = new PortalGroup(this.world, groupsTag.func_74775_l(key));
            this.groups.add(group);
            group.shape.frame.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
            group.shape.area.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
        }
    }

    private CompoundNBT writeGroup(PortalGroup group) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("group", (INBT)group.write());
        return tag;
    }

    public void readGroup(CompoundNBT tag) {
        if (tag.func_74764_b("group")) {
            PortalGroup group = new PortalGroup(this.world, tag.func_74775_l("group"));
            this.groups.add(group);
            group.shape.frame.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
            group.shape.area.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
        }
    }
}

