/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.google.gson.JsonObject;
import com.supermartijn642.wormhole.Wormhole;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class NBTRecipe
extends ShapedRecipe {
    public static final List<Item> VALID_ITEMS = new LinkedList<Item>();

    public NBTRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        CompoundNBT compound = null;
        block0: for (int i = 0; i < inv.func_174923_h(); ++i) {
            for (int j = 0; j < inv.func_174922_i(); ++j) {
                ItemStack stack = inv.func_70301_a(i * inv.func_174922_i() + j);
                if (!stack.func_77942_o() || !VALID_ITEMS.contains(stack.func_77973_b())) continue;
                compound = stack.func_77978_p();
                break block0;
            }
        }
        if (compound != null) {
            ItemStack result = this.func_77571_b().func_77946_l();
            result.func_196082_o().func_197643_a(compound);
            return result;
        }
        return this.func_77571_b().func_77946_l();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return super.func_199559_b();
    }

    static {
        VALID_ITEMS.add(Wormhole.target_device);
        VALID_ITEMS.add(Wormhole.advanced_target_device);
        VALID_ITEMS.add(Item.func_150898_a((Block)Wormhole.portal_stabilizer));
        VALID_ITEMS.add(Item.func_150898_a((Block)Wormhole.basic_energy_cell));
        VALID_ITEMS.add(Item.func_150898_a((Block)Wormhole.advanced_energy_cell));
        VALID_ITEMS.add(Item.func_150898_a((Block)Wormhole.basic_target_cell));
        VALID_ITEMS.add(Item.func_150898_a((Block)Wormhole.advanced_target_cell));
        VALID_ITEMS.add(Item.func_150898_a((Block)Wormhole.coal_generator));
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<NBTRecipe> {
        public NBTRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json);
            return new NBTRecipe(recipeId, recipe.func_193358_e(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b());
        }

        @Nullable
        public NBTRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapedRecipe recipe = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer);
            return new NBTRecipe(recipeId, recipe.func_193358_e(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b());
        }

        public void toNetwork(PacketBuffer buffer, NBTRecipe recipe) {
            IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe);
        }
    }
}

