/*
 * Decompiled with CFR 0.152.
 */
package commoble.entitydetectors.items;

import commoble.entitydetectors.items.ItemRegistrar;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class ImprintedSlimeballItem
extends Item {
    public static final String ENTITY_KEY = "entity";
    public static final EnumSet<EntityClassification> VALID_ENTITY_CLASSIFICATIONS = EnumSet.of(EntityClassification.CREATURE, EntityClassification.MONSTER, EntityClassification.WATER_CREATURE);

    public ImprintedSlimeballItem(Item.Properties properties) {
        super(properties);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent baseName = super.func_200295_i(stack);
        return ImprintedSlimeballItem.getEntityType(stack).map(EntityType::func_210760_d).map(TranslationTextComponent::new).map(entityName -> ImprintedSlimeballItem.getDisplayName(entityName, baseName)).orElse(baseName);
    }

    public static ITextComponent getDisplayName(TranslationTextComponent entityName, ITextComponent baseName) {
        return new StringTextComponent("").func_230529_a_(baseName).func_240702_b_(" (").func_230529_a_((ITextComponent)entityName).func_240702_b_(")");
    }

    public static ItemStack createItemStackForEntityType(EntityType<?> entityType) {
        ItemStack stack = new ItemStack((IItemProvider)ItemRegistrar.IMPRINTED_SLIME_BALL);
        stack.func_77983_a(ENTITY_KEY, (INBT)StringNBT.func_229705_a_((String)entityType.getRegistryName().toString()));
        return stack;
    }

    public static Optional<EntityType<?>> getEntityType(ItemStack stack) {
        if (stack.func_190916_E() < 0) {
            return Optional.empty();
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(ENTITY_KEY)) {
            return Optional.empty();
        }
        return Optional.of(ForgeRegistries.ENTITIES.getValue(new ResourceLocation(nbt.func_74779_i(ENTITY_KEY))));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ForgeRegistries.ENTITIES.getValues().stream().filter(ImprintedSlimeballItem::isEntityTypeValid).forEachOrdered(entityType -> items.add((Object)ImprintedSlimeballItem.createItemStackForEntityType(entityType)));
        }
    }

    public static boolean isEntityTypeValid(EntityType<?> entityType) {
        return VALID_ENTITY_CLASSIFICATIONS.contains(entityType.func_220339_d());
    }
}

