/*
 * Decompiled with CFR 0.152.
 */
package commoble.entitydetectors;

import commoble.entitydetectors.Config;
import commoble.entitydetectors.ConfigHelper;
import commoble.entitydetectors.Registrator;
import commoble.entitydetectors.blocks.BlockRegistrar;
import commoble.entitydetectors.blocks.TileEntityRegistrar;
import commoble.entitydetectors.client.ClientEvents;
import commoble.entitydetectors.items.ImprintedSlimeballItem;
import commoble.entitydetectors.items.ItemRegistrar;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="entitydetectors")
public class EntityDetectors {
    public static final String MODID = "entitydetectors";
    public static Config config;

    public EntityDetectors() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        config = ConfigHelper.register(ModConfig.Type.SERVER, Config::new);
        modBus.addGenericListener(Block.class, EntityDetectors.getRegistryHandler(BlockRegistrar::onRegisterBlocks));
        modBus.addGenericListener(Item.class, EntityDetectors.getRegistryHandler(ItemRegistrar::onRegisterItems));
        modBus.addGenericListener(TileEntityType.class, EntityDetectors.getRegistryHandler(TileEntityRegistrar::onRegisterTileEntities));
        forgeBus.addListener(EntityDetectors::onPlayerInteractWithEntity);
        forgeBus.addListener(EntityDetectors::onPlayerAttackEntity);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEvents.subscribeClientEvents(modBus, forgeBus));
    }

    public static void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        PlayerEntity player = event.getPlayer();
        ItemStack oldStack = event.getItemStack();
        EntityType entityType = event.getTarget().func_200600_R();
        EntityDetectors.onPlayerAttackedOrInteractedWithEntity(player, oldStack, entityType);
    }

    public static void onPlayerAttackEntity(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemStack oldStack = player.func_184614_ca();
        EntityType entityType = event.getTarget().func_200600_R();
        EntityDetectors.onPlayerAttackedOrInteractedWithEntity(player, oldStack, entityType);
    }

    public static void onPlayerAttackedOrInteractedWithEntity(PlayerEntity player, ItemStack oldStack, EntityType<?> entityType) {
        if (oldStack.func_77973_b() == Items.field_151123_aH && ImprintedSlimeballItem.isEntityTypeValid(entityType)) {
            oldStack.func_190918_g(1);
            ItemStack newSlimeStack = ImprintedSlimeballItem.createItemStackForEntityType(entityType);
            if (!player.func_191521_c(newSlimeStack)) {
                player.func_71019_a(newSlimeStack, false);
            }
        }
    }

    public static <T extends IForgeRegistryEntry<T>> Consumer<RegistryEvent.Register<T>> getRegistryHandler(Consumer<Registrator<T>> consumer) {
        return event -> consumer.accept(new Registrator(event.getRegistry()));
    }
}

