/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.util;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.configuration.ConfigCache;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.util.People;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;

public class BackpackUtils {
    public static boolean curiosLoaded = false;

    public static boolean filterItem(ItemStack stack) {
        if (ConfigCache.WHITELIST.contains(stack.func_77973_b().getRegistryName())) {
            return true;
        }
        if (stack.func_77973_b().func_206844_a(SimplyBackpacks.HOLDS_ITEMS)) {
            return false;
        }
        return !ConfigCache.BLACKLIST.contains(stack.func_77973_b().getRegistryName());
    }

    public static ItemStack findBackpackForHotkeys(PlayerEntity player) {
        ItemStack stack;
        if (player.func_184614_ca().func_77973_b() instanceof BackpackItem) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() instanceof BackpackItem) {
            return player.func_184592_cb();
        }
        if (curiosLoaded && !(stack = CuriosApi.getCuriosHelper().findEquippedCurio(BackpackItem::isBackpack, (LivingEntity)player).map(data -> {
            if (((ItemStack)data.getRight()).func_77973_b() instanceof BackpackItem) {
                return (ItemStack)data.getRight();
            }
            return ItemStack.field_190927_a;
        }).orElse(ItemStack.field_190927_a)).func_190926_b()) {
            return stack;
        }
        PlayerInventory inventory = player.field_71071_by;
        for (int i = 0; i <= 35; ++i) {
            ItemStack stack2 = inventory.func_70301_a(i);
            if (!(stack2.func_77973_b() instanceof BackpackItem)) continue;
            return stack2;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static Optional<UUID> getUUID(@Nonnull ItemStack stack) {
        if (stack.func_77973_b() instanceof BackpackItem && stack.func_77942_o() && stack.func_77978_p().func_74764_b("UUID")) {
            return Optional.of(stack.func_77978_p().func_186857_a("UUID"));
        }
        return Optional.empty();
    }

    public static boolean increasedAltChance(UUID uuidIn) {
        if (uuidIn.compareTo(People.FLANKS255) == 0) {
            return true;
        }
        return uuidIn.compareTo(People.LONEZTAR) == 0;
    }

    public static Set<String> getUUIDSuggestions(CommandContext<CommandSource> commandSource) {
        BackpackManager backpacks = BackpackManager.get();
        HashSet<String> list = new HashSet<String>();
        backpacks.getMap().forEach((uuid, backpackData) -> list.add(uuid.toString()));
        return list;
    }
}

