/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.inventory;

import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.items.Backpack;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;

public class BackpackManager
extends WorldSavedData {
    private static final String NAME = "simplybackpacks_backpack_data";
    private static final HashMap<UUID, BackpackData> data = new HashMap();
    public static final BackpackManager blankClient = new BackpackManager();

    public BackpackManager() {
        super(NAME);
    }

    public HashMap<UUID, BackpackData> getMap() {
        return data;
    }

    public static BackpackManager get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (BackpackManager)ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(BackpackManager::new, NAME);
        }
        return blankClient;
    }

    public Optional<BackpackData> getBackpack(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public BackpackData getOrCreateBackpack(UUID uuid, Backpack tier) {
        return data.computeIfAbsent(uuid, id -> {
            this.func_76185_a();
            return new BackpackData((UUID)id, tier);
        });
    }

    public LazyOptional<IItemHandler> getCapability(UUID uuid) {
        if (data.containsKey(uuid)) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public LazyOptional<IItemHandler> getCapability(ItemStack stack) {
        UUID uuid;
        if (stack.func_196082_o().func_74764_b("UUID") && data.containsKey(uuid = stack.func_77978_p().func_186857_a("UUID"))) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("Backpacks")) {
            ListNBT list = nbt.func_150295_c("Backpacks", 10);
            list.forEach(backpackNBT -> BackpackData.fromNBT((CompoundNBT)backpackNBT).ifPresent(backpack -> data.put(backpack.getUuid(), (BackpackData)backpack)));
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT backpacks = new ListNBT();
        data.forEach((uuid, backpackData) -> backpacks.add((Object)backpackData.toNBT()));
        compound.func_218657_a("Backpacks", (INBT)backpacks);
        return compound;
    }
}

