/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.inventory;

import com.flanks255.simplybackpacks.inventory.FilterItemHandler;
import com.flanks255.simplybackpacks.inventory.SBItemHandler;
import com.flanks255.simplybackpacks.items.Backpack;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class BackpackData {
    private final UUID uuid;
    private Backpack tier;
    private final SBItemHandler inventory;
    private final LazyOptional<IItemHandler> optional;
    public final Metadata meta = new Metadata();
    private FilterItemHandler filter = new FilterItemHandler();

    public LazyOptional<IItemHandler> getOptional() {
        return this.optional;
    }

    public IItemHandler getHandler() {
        return this.inventory;
    }

    public FilterItemHandler getFilter() {
        return this.filter;
    }

    public Backpack getTier() {
        return this.tier;
    }

    public void updateAccessRecords(String player, long time) {
        if (this.meta.firstAccessedTime == 0L) {
            this.meta.firstAccessedTime = time;
            this.meta.firstAccessedPlayer = player;
        }
        this.meta.setLastAccessedTime(time);
        this.meta.setLastAccessedPlayer(player);
    }

    public BackpackData(UUID uuid, Backpack tier) {
        this.uuid = uuid;
        this.tier = tier;
        this.inventory = new SBItemHandler(tier.slots);
        this.optional = LazyOptional.of(() -> this.inventory);
    }

    public BackpackData(UUID uuid, CompoundNBT incomingNBT) {
        this.uuid = uuid;
        this.tier = Backpack.values()[Math.min(incomingNBT.func_74762_e("Tier"), Backpack.ULTIMATE.ordinal())];
        this.inventory = new SBItemHandler(this.tier.slots);
        this.inventory.deserializeNBT(incomingNBT.func_74775_l("Inventory"));
        this.filter = new FilterItemHandler();
        this.filter.deserializeNBT(incomingNBT.func_74775_l("Filter"));
        this.optional = LazyOptional.of(() -> this.inventory);
        if (incomingNBT.func_74764_b("Metadata")) {
            this.meta.deserializeNBT(incomingNBT.func_74775_l("Metadata"));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static Optional<BackpackData> fromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("UUID")) {
            UUID uuid = nbt.func_186857_a("UUID");
            return Optional.of(new BackpackData(uuid, nbt));
        }
        return Optional.empty();
    }

    public void upgrade(Backpack newTier) {
        if (newTier.ordinal() > this.tier.ordinal()) {
            this.tier = newTier;
            this.inventory.upgrade(this.tier.slots);
        }
    }

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_186854_a("UUID", this.uuid);
        nbt.func_74768_a("Tier", this.tier.ordinal());
        nbt.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        nbt.func_218657_a("Filter", (INBT)this.filter.serializeNBT());
        nbt.func_218657_a("Metadata", (INBT)this.meta.serializeNBT());
        return nbt;
    }

    public static class Metadata
    implements INBTSerializable<CompoundNBT> {
        private String firstAccessedPlayer = "";
        private long firstAccessedTime = 0L;
        private String lastAccessedPlayer = "";
        private long lastAccessedTime = 0L;

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        public String getLastAccessedPlayer() {
            return this.lastAccessedPlayer;
        }

        public void setLastAccessedPlayer(String lastAccessedPlayer) {
            this.lastAccessedPlayer = lastAccessedPlayer;
        }

        public long getFirstAccessedTime() {
            return this.firstAccessedTime;
        }

        public String getFirstAccessedPlayer() {
            return this.firstAccessedPlayer;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("firstPlayer", this.firstAccessedPlayer);
            nbt.func_74772_a("firstTime", this.firstAccessedTime);
            nbt.func_74778_a("lastPlayer", this.lastAccessedPlayer);
            nbt.func_74772_a("lastTime", this.lastAccessedTime);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.firstAccessedPlayer = nbt.func_74779_i("firstPlayer");
            this.firstAccessedTime = nbt.func_74763_f("firstTime");
            this.lastAccessedPlayer = nbt.func_74779_i("lastPlayer");
            this.lastAccessedTime = nbt.func_74763_f("lastTime");
        }
    }
}

