/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class TargetNBTIngredient
extends Ingredient {
    public static final Serializer SERIALIZER = new Serializer();

    public TargetNBTIngredient(Stream<? extends Ingredient.IItemList> itemLists) {
        super(itemLists);
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static TargetNBTIngredient of(IItemProvider itemProvider) {
        return new TargetNBTIngredient(Stream.of(new Ingredient.SingleItemList(new ItemStack(itemProvider))));
    }

    public static TargetNBTIngredient of(ItemStack itemStack) {
        return new TargetNBTIngredient(Stream.of(new Ingredient.SingleItemList(itemStack)));
    }

    public static TargetNBTIngredient of(ITag tag) {
        return new TargetNBTIngredient(Stream.of(new Ingredient.TagList(tag)));
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject tmp = super.func_200304_c().getAsJsonObject();
        tmp.addProperty("type", Serializer.NAME.toString());
        return tmp;
    }

    public static class Serializer
    implements IIngredientSerializer<TargetNBTIngredient> {
        public static final ResourceLocation NAME = new ResourceLocation("simplybackpacks", "nbt_target");

        @Nonnull
        public TargetNBTIngredient parse(PacketBuffer buffer) {
            return new TargetNBTIngredient(Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()));
        }

        @Nonnull
        public TargetNBTIngredient parse(@Nonnull JsonObject json) {
            return new TargetNBTIngredient(Stream.of(Ingredient.func_199803_a((JsonObject)json)));
        }

        public void write(PacketBuffer buffer, TargetNBTIngredient ingredient) {
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }
    }
}

