/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.crop;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.darkhax.bookshelf.block.DisplayableBlockState;
import net.darkhax.bookshelf.crafting.RecipeDataBase;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

public class CropInfo
extends RecipeDataBase {
    private Ingredient seed;
    private Set<String> soilCategories;
    private int growthTicks;
    private List<HarvestEntry> results;
    private DisplayableBlockState[] displayBlocks;
    private Optional<Integer> lightLevel;

    public CropInfo(ResourceLocation id, Ingredient seed, Set<String> soilCategories, int growthTicks, List<HarvestEntry> results, DisplayableBlockState[] displayStates, Optional<Integer> lightLevel) {
        super(id);
        this.seed = seed;
        this.soilCategories = soilCategories;
        this.growthTicks = growthTicks;
        this.results = results;
        this.displayBlocks = displayStates;
        this.lightLevel = lightLevel;
    }

    public Ingredient getSeed() {
        return this.seed;
    }

    public Set<String> getSoilCategories() {
        return this.soilCategories;
    }

    public List<HarvestEntry> getResults() {
        return this.results;
    }

    public DisplayableBlockState[] getDisplayState() {
        return this.displayBlocks;
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    public int getGrowthTicksForSoil(SoilInfo soil) {
        float requiredGrowthTicks = this.growthTicks;
        float growthModifier = soil.getGrowthModifier();
        if (growthModifier > -1.0f) {
            return MathHelper.func_76141_d((float)(requiredGrowthTicks * (1.0f + growthModifier * -1.0f)));
        }
        return -1;
    }

    public void setSeed(Ingredient seed) {
        this.seed = seed;
    }

    public void setSoilCategories(Set<String> soilCategories) {
        this.soilCategories = soilCategories;
    }

    public void setGrowthTicks(int growthTicks) {
        this.growthTicks = growthTicks;
    }

    public void setResults(List<HarvestEntry> results) {
        this.results = results;
    }

    public void setDisplayBlock(DisplayableBlockState[] displayBlocks) {
        this.displayBlocks = displayBlocks;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return BotanyPots.instance.getContent().recipeSerializerCrop;
    }

    public IRecipeType<?> func_222127_g() {
        return BotanyPots.instance.getContent().recipeTypeCrop;
    }

    public ITextComponent getName() {
        return new TranslationTextComponent(this.getDisplayState()[0].getState().func_177230_c().func_149739_a());
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = Optional.of(lightLevel);
    }

    public Optional<Integer> getLightLevel() {
        return this.lightLevel;
    }

    public int getLightLevel(IBlockReader world, BlockPos pos) {
        return this.getLightLevel().orElseGet(() -> this.getDisplayState()[0].getState().getLightValue(world, pos));
    }
}

