/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.ui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.ui.ScreenKubeJSUI;
import dev.latvian.kubejs.ui.UIData;
import dev.latvian.kubejs.ui.UIEventJS;
import dev.latvian.kubejs.ui.widget.Panel;
import dev.latvian.kubejs.ui.widget.UI;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.Nullable;

public class Widget
extends AbstractGui {
    public Panel parent;
    private int x = 0;
    private int y = 0;
    private int width = 16;
    private int height = 16;
    public int z = 0;
    private Text name = Text.of((Object)"");
    private Consumer<Screen> action = null;
    public int alpha = 255;
    public boolean enabled = true;
    private SoundEvent clickSound = SoundEvents.field_187909_gi;
    public Runnable mouseEnter = null;
    public Runnable mouseExit = null;
    public int color = 0xFFFFFF;
    public int hoverColor = 0xFFFFFF;
    public List<ITextComponent> hoverTextComponents;
    protected ITextComponent cachedComponent = StringTextComponent.field_240750_d_;
    public int actualX = 0;
    public int actualY = 0;
    public boolean isMouseOver = false;

    public UI getUi() {
        return this.parent.getUi();
    }

    public int getX() {
        return this.x + this.parent.getX();
    }

    public void setX(int _x) {
        this.x = _x;
    }

    public final void setX(double _x) {
        this.setX(MathHelper.func_76128_c((double)_x));
    }

    public int getY() {
        return this.y + this.parent.getY();
    }

    public void setY(int _y) {
        this.y = _y;
    }

    public final void setY(double _y) {
        this.setY(MathHelper.func_76128_c((double)_y));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public double getActualWidth() {
        return (double)this.getWidth() / this.getUi().getScale();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public double getActualHeight() {
        return (double)this.getHeight() / this.getUi().getScale();
    }

    public Text getName() {
        return this.name;
    }

    public void setName(Text o) {
        this.name = o;
        this.cachedComponent = this.name.component();
    }

    @Nullable
    public Consumer<Screen> getAction() {
        return this.action;
    }

    public void setAction(Consumer<Screen> r) {
        this.action = r;
    }

    public void setAction(String id) {
        if (id.startsWith("$")) {
            this.setAction((Screen s) -> {
                try {
                    UIEventJS e = new UIEventJS();
                    if (e.post(ScriptType.CLIENT, "ui." + id) && e.consumer != null) {
                        Minecraft.func_71410_x().func_147108_a((Screen)new ScreenKubeJSUI(id, (Screen)s, e.consumer, e.forcedScale));
                    }
                }
                catch (Exception ex) {
                    ScriptType.CLIENT.console.error((Object)("Failed to create " + id + " UI:"));
                    ex.printStackTrace();
                }
            });
        } else if (id.startsWith("http://") || id.startsWith("https://")) {
            this.setAction((Screen screen) -> this.getUi().screen.func_230455_a_(Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, id))));
        } else {
            this.setAction(UIData.INSTANCE.getAction(id));
        }
    }

    public void setClickSound(SoundEvent e) {
        this.clickSound = e;
    }

    public void setClickSound(String sound) {
        this.setClickSound((SoundEvent)Registry.field_212633_v.func_82594_a(UtilsJS.getMCID((Object)sound)));
    }

    public void collectWidgets(List<Widget> list) {
        list.add(this);
    }

    public void renderBackground(MatrixStack matrixStack, float partialTicks) {
    }

    public void renderForeground(MatrixStack matrixStack, float partialTicks) {
    }

    public boolean mousePressed() {
        if (this.isMouseOver && this.getAction() != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)this.clickSound, (float)1.0f));
            this.getAction().accept(this.getUi().screen);
            return true;
        }
        return false;
    }

    public void mouseReleased() {
    }

    public void setHoverText(Object[] array) {
        this.hoverTextComponents = new ArrayList<ITextComponent>(array.length);
        for (Object o : array) {
            this.hoverTextComponents.add(Text.of((Object)o).component());
        }
    }

    public void setHoverText(Object o) {
        this.setHoverText(new Object[]{o});
    }

    public void appendHoverText(List<ITextComponent> list) {
        if (this.hoverTextComponents != null && this.isMouseOver) {
            list.addAll(this.hoverTextComponents);
        }
    }
}

