/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.ui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.latvian.kubejs.ui.KubeJSUIOptions;
import dev.latvian.kubejs.ui.widget.Button;
import dev.latvian.kubejs.ui.widget.Image;
import dev.latvian.kubejs.ui.widget.ImageButton;
import dev.latvian.kubejs.ui.widget.Label;
import dev.latvian.kubejs.ui.widget.Panorama;
import dev.latvian.kubejs.ui.widget.Shader;
import dev.latvian.kubejs.ui.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class Panel
extends Widget {
    public final List<Widget> children = new ArrayList<Widget>();

    @Override
    public void collectWidgets(List<Widget> list) {
        super.collectWidgets(list);
        for (Widget w : this.children) {
            w.collectWidgets(list);
        }
    }

    public <W extends Widget> void widget(Supplier<W> s, Consumer<W> c) {
        Widget w = (Widget)((Object)s.get());
        w.parent = this;
        this.children.add(w);
        c.accept((W)((Object)w));
    }

    public void panel(Consumer<Panel> c) {
        this.widget(Panel::new, c);
    }

    public void button(Consumer<Button> c) {
        this.widget(Button::new, c);
    }

    public void imageButton(Consumer<ImageButton> c) {
        this.widget(ImageButton::new, c);
    }

    public void label(Consumer<Label> c) {
        this.widget(Label::new, c);
    }

    public void image(Consumer<Image> c) {
        this.widget(Image::new, c);
    }

    public void background(String texture) {
        this.image(image -> {
            image.setTexture(texture);
            image.setX(0);
            image.setY(0);
            image.setWidth(this.getWidth());
            image.setHeight(this.getHeight());
        });
    }

    public void tilingBackground(String texture, int size) {
        this.image(image -> {
            image.setTexture(texture);
            image.setTileSize(size);
            image.setX(0);
            image.setY(0);
            image.setWidth(this.getWidth());
            image.setHeight(this.getHeight());
        });
    }

    public void fillBackground(String texture, int tw, int th) {
        this.image(image -> {
            image.setTexture(texture);
            double fw = (double)this.getWidth() / (double)tw;
            double fh = (double)this.getHeight() / (double)th;
            if (fw > fh) {
                image.setWidth((int)((double)tw * fw));
                image.setHeight((int)((double)th * fw));
            } else {
                image.setWidth((int)((double)tw * fh));
                image.setHeight((int)((double)th * fh));
            }
            image.setX((this.getWidth() - image.getWidth()) / 2);
            image.setY((this.getHeight() - image.getHeight()) / 2);
        });
    }

    public void shaderBackground(String s, int scale) {
        if (KubeJSUIOptions.getInstance().useShaders) {
            this.widget(() -> new Shader(this.getUi().screen.loadShader(new ResourceLocation(s)).orElse(null), scale), shader -> {
                shader.setX(0);
                shader.setY(0);
                shader.setWidth(this.getWidth());
                shader.setHeight(this.getHeight());
            });
        }
    }

    public void shaderBackground(String s) {
        this.shaderBackground(s, KubeJSUIOptions.getInstance().defaultShaderScale);
    }

    public void minecraftLogo(int x, int y) {
        this.image(i -> {
            i.setTexture("minecraft:textures/gui/title/minecraft.png");
            i.setX(x);
            i.setY(y);
            i.setWidth(155);
            i.setHeight(44);
            i.setUv(new int[]{0, 0, 155, 44});
        });
        this.image(i -> {
            i.setTexture("minecraft:textures/gui/title/minecraft.png");
            i.setX(x + 155);
            i.setY(y);
            i.setWidth(155);
            i.setHeight(44);
            i.setUv(new int[]{0, 45, 155, 44});
        });
    }

    public void minecraftLogo(int y) {
        this.minecraftLogo(this.getWidth() / 2 - 137, y);
    }

    public void panorama(ResourceLocation cubeMap) {
        this.widget(() -> new Panorama(cubeMap), shader -> {
            shader.setX(0);
            shader.setY(0);
            shader.setWidth(this.getWidth());
            shader.setHeight(this.getHeight());
        });
    }

    public void minecraftPanorama() {
        this.panorama(new ResourceLocation("textures/gui/title/background/panorama"));
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, float partialTicks) {
        for (Widget w : this.children) {
            w.renderBackground(matrixStack, partialTicks);
        }
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, float partialTicks) {
        for (Widget w : this.children) {
            w.renderForeground(matrixStack, partialTicks);
        }
    }

    @Override
    public boolean mousePressed() {
        for (Widget w : this.children) {
            if (!w.mousePressed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased() {
        for (Widget w : this.children) {
            w.mouseReleased();
        }
    }

    @Override
    public void appendHoverText(List<ITextComponent> list) {
        super.appendHoverText(list);
        for (Widget w : this.children) {
            w.appendHoverText(list);
        }
    }
}

