/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape.tape;

import gigaherz.packingtape.ConfigValues;
import gigaherz.packingtape.PackingTapeMod;
import gigaherz.packingtape.tape.PackagedBlock;
import gigaherz.packingtape.tape.PackagedBlockEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class TapeItem
extends Item {
    public TapeItem(Item.Properties properties) {
        super(properties);
    }

    public int getMaxDamage(ItemStack stack) {
        return ConfigValues.tapeRollUses;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77952_i() == 0 ? super.getItemStackLimit(stack) : 1;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity playerIn = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        if (stack.func_190916_E() <= 0) {
            return ActionResultType.PASS;
        }
        BlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return ActionResultType.PASS;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && ConfigValues.consumesPaper && !this.hasPaper(playerIn)) {
            TranslationTextComponent textComponent = new TranslationTextComponent("text.packingtape.tape.requires_paper");
            playerIn.func_146105_b((ITextComponent)textComponent, true);
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (ConfigValues.isTileEntityBlocked(te)) {
            return ActionResultType.PASS;
        }
        if (state.func_177230_c() instanceof ChestBlock && state.func_235901_b_((Property)ChestBlock.field_196314_b) && state.func_177229_b((Property)ChestBlock.field_196314_b) != ChestType.SINGLE) {
            state = (BlockState)state.func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE);
        }
        CompoundNBT tag = te.func_189515_b(new CompoundNBT());
        world.func_175713_t(pos);
        world.func_175656_a(pos, ((PackagedBlock)PackingTapeMod.PACKAGED_BLOCK.get()).func_176223_P());
        TileEntity te2 = world.func_175625_s(pos);
        if (te2 instanceof PackagedBlockEntity) {
            PackagedBlockEntity packaged = (PackagedBlockEntity)te2;
            packaged.setContents(state, tag);
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            if (ConfigValues.consumesPaper) {
                this.usePaper(playerIn);
            }
            if (stack.func_190916_E() > 1) {
                ItemStack split = stack.func_77946_l();
                split.func_190920_e(1);
                split.func_196085_b(split.func_77952_i() + 1);
                if (stack.func_77952_i() < stack.func_77958_k()) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)split);
                }
                stack.func_190918_g(1);
            } else {
                stack.func_196085_b(stack.func_77952_i() + 1);
                if (stack.func_77952_i() >= stack.func_77958_k()) {
                    stack.func_190918_g(1);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private boolean hasPaper(PlayerEntity playerIn) {
        ItemStack stack = playerIn.func_184582_a(EquipmentSlotType.OFFHAND);
        if (stack.func_77973_b() == Items.field_151121_aF) {
            return true;
        }
        PlayerInventory inv = playerIn.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != Items.field_151121_aF) continue;
            return true;
        }
        return false;
    }

    private void usePaper(PlayerEntity playerIn) {
        ItemStack stack = playerIn.func_184582_a(EquipmentSlotType.OFFHAND);
        if (stack.func_77973_b() == Items.field_151121_aF) {
            stack.func_190917_f(-1);
            if (stack.func_190916_E() <= 0) {
                playerIn.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
            }
        }
        PlayerInventory inv = playerIn.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != Items.field_151121_aF) continue;
            stack.func_190917_f(-1);
            if (stack.func_190916_E() <= 0) {
                inv.func_70299_a(i, ItemStack.field_190927_a);
            }
            return;
        }
    }
}

