/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.util;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;

public class WorldHelper {
    public static BiPredicate<World, BlockPos> isPlayerNear(PlayerEntity playerEntity) {
        WeakReference<PlayerEntity> playerEntityWeakReference = new WeakReference<PlayerEntity>(playerEntity);
        return (world, blockPos) -> {
            PlayerEntity playerReference = (PlayerEntity)playerEntityWeakReference.get();
            if (playerReference != null) {
                return playerEntity.func_70092_e((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5) <= 64.0;
            }
            return false;
        };
    }

    public static boolean isEntityChunkLoaded(IWorld world, ChunkPos pos) {
        return world.func_72863_F().func_222865_a(pos);
    }

    public static boolean isEntityChunkLoaded(IWorld world, int x, int z) {
        return WorldHelper.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static <T extends Entity> List<T> getEntitiesWithinAABB(@Nonnull IWorld world, @Nonnull Class<? extends T> clazz, @Nonnull AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super T> predicate) {
        int minX = (int)(Math.round(axisAlignedBB.field_72340_a) >> 4);
        int maxX = (int)(Math.round(axisAlignedBB.field_72336_d) >> 4);
        int minZ = (int)(Math.round(axisAlignedBB.field_72339_c) >> 4);
        int maxZ = (int)(Math.round(axisAlignedBB.field_72339_c) >> 4);
        int minY = (int)(Math.round(axisAlignedBB.field_72338_b) >> 4);
        int maxY = (int)(Math.round(axisAlignedBB.field_72337_e) >> 4);
        ArrayList list = Lists.newArrayList();
        AbstractChunkProvider abstractchunkprovider = world.func_72863_F();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                Chunk chunk;
                if (!WorldHelper.isEntityChunkLoaded(world, x, z) || (chunk = abstractchunkprovider.func_225313_a(x, z)) == null) continue;
                for (int y = minY; y <= maxY; ++y) {
                    for (Entity entity : chunk.func_177429_s()[y].func_219790_a(clazz)) {
                        if (!axisAlignedBB.func_72318_a(entity.func_213303_ch()) || predicate != null && !predicate.test(entity)) continue;
                        list.add(entity);
                    }
                }
            }
        }
        return list;
    }
}

