/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;

public class RailShapeHelper {
    public static List<RailShape> CURVED_RAILS = Lists.newArrayList((Object[])new RailShape[]{RailShape.NORTH_EAST, RailShape.SOUTH_EAST, RailShape.SOUTH_WEST, RailShape.NORTH_WEST});
    public static List<RailShape> STRAIGHT_RAILS = Lists.newArrayList((Object[])new RailShape[]{RailShape.NORTH_SOUTH, RailShape.EAST_WEST});
    public static List<RailShape> ASCENDING_RAILS = Lists.newArrayList((Object[])new RailShape[]{RailShape.ASCENDING_NORTH, RailShape.ASCENDING_EAST, RailShape.ASCENDING_SOUTH, RailShape.ASCENDING_WEST});

    @Nonnull
    public static BlockState nextBending(BlockState blockState, Property<RailShape> property, boolean major) {
        if (major) {
            RailShape currentRailShape = (RailShape)blockState.func_177229_b(property);
            Collection allowedValues = property.func_177700_c();
            ArrayList tries = Lists.newArrayList();
            if (CURVED_RAILS.contains(currentRailShape)) {
                tries.addAll(STRAIGHT_RAILS);
                tries.addAll(ASCENDING_RAILS);
            } else if (STRAIGHT_RAILS.contains(currentRailShape)) {
                tries.addAll(ASCENDING_RAILS);
                tries.addAll(CURVED_RAILS);
            } else if (ASCENDING_RAILS.contains(currentRailShape)) {
                tries.addAll(CURVED_RAILS);
                tries.addAll(STRAIGHT_RAILS);
            }
            tries.retainAll(allowedValues);
            if (tries.isEmpty()) {
                return blockState;
            }
            return (BlockState)blockState.func_206870_a(property, (Comparable)((RailShape)tries.get(0)));
        }
        return (BlockState)blockState.func_235896_a_(property);
    }
}

