/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tileentity;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.capability.itemhandler.ModularItemStackHandler;
import xyz.brassgoggledcoders.transport.container.moduleconfigurator.ModuleConfiguratorContainer;
import xyz.brassgoggledcoders.transport.loot.entry.ILootDrop;

public class ModuleConfiguratorTileEntity
extends TileEntity
implements INamedContainerProvider,
ILootDrop {
    private final ModularItemStackHandler modularItemStackHandler = new ModularItemStackHandler(this::getTheWorld, this::onChange);
    private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(() -> this.modularItemStackHandler);

    public ModuleConfiguratorTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public ActionResultType openScreen(PlayerEntity playerEntity) {
        if (!playerEntity.func_213453_ef()) {
            if (!this.getTheWorld().func_201670_d() && playerEntity instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)this);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public World getTheWorld() {
        return Objects.requireNonNull(this.field_145850_b);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a()).func_240699_a_(TextFormatting.BLACK);
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ModuleConfiguratorContainer(windowId, playerInventory, IWorldPosCallable.func_221488_a((World)this.getTheWorld(), (BlockPos)this.func_174877_v()), this.modularItemStackHandler);
    }

    @Nonnull
    public LazyOptional<IModularEntity> getModularEntity() {
        return this.modularItemStackHandler.getModularEntity();
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        CompoundNBT compoundNBT = super.func_189515_b(compound);
        compoundNBT.func_218657_a("modularInventory", (INBT)this.modularItemStackHandler.serializeNBT());
        return compoundNBT;
    }

    @ParametersAreNonnullByDefault
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.modularItemStackHandler.deserializeNBT(compound.func_74775_l("modularInventory"));
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT compoundNBT = super.func_189517_E_();
        compoundNBT.func_218657_a("modularInventory", (INBT)this.modularItemStackHandler.serializeNBT());
        return compoundNBT;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.modularItemStackHandler.deserializeNBT(tag.func_74775_l("modularInventory"));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compoundNBT = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), compoundNBT);
    }

    public void onChange() {
        this.getTheWorld().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyOptional.cast();
        }
        return super.getCapability(capability, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.lazyOptional.invalidate();
    }

    @Override
    public void onLootDrop(Consumer<ItemStack> itemStackConsumer) {
        this.modularItemStackHandler.forEach(itemStackConsumer);
    }
}

