/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.repack.registrate.builders;

import javax.annotation.Nullable;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import xyz.brassgoggledcoders.transport.repack.registrate.AbstractRegistrate;
import xyz.brassgoggledcoders.transport.repack.registrate.builders.AbstractBuilder;
import xyz.brassgoggledcoders.transport.repack.registrate.builders.BuilderCallback;
import xyz.brassgoggledcoders.transport.repack.registrate.util.entry.ContainerEntry;
import xyz.brassgoggledcoders.transport.repack.registrate.util.entry.RegistryEntry;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonNullSupplier;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonnullType;

public class ContainerBuilder<T extends Container, S extends Screen, P>
extends AbstractBuilder<ContainerType<?>, ContainerType<T>, P, ContainerBuilder<T, S, P>> {
    private final ForgeContainerFactory<T> factory;
    private final NonNullSupplier<ScreenFactory<T, S>> screenFactory;

    public ContainerBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ContainerFactory<T> factory, NonNullSupplier<ScreenFactory<T, S>> screenFactory) {
        this(owner, parent, name, callback, (ContainerType<T> type, int windowId, PlayerInventory inv, PacketBuffer $) -> factory.create(type, windowId, inv), screenFactory);
    }

    public ContainerBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ForgeContainerFactory<T> factory, NonNullSupplier<ScreenFactory<T, S>> screenFactory) {
        super(owner, parent, name, callback, ContainerType.class);
        this.factory = factory;
        this.screenFactory = screenFactory;
    }

    @Override
    @NonnullType
    protected ContainerType<T> createEntry() {
        ForgeContainerFactory factory = this.factory;
        NonNullSupplier supplier = this.asSupplier();
        ContainerType ret = IForgeContainerType.create((windowId, inv, buf) -> factory.create((ContainerType)supplier.get(), windowId, inv, buf));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ScreenFactory screenFactory = this.screenFactory.get();
            ScreenManager.func_216911_a((ContainerType)ret, (type, inv, displayName) -> screenFactory.create(type, inv, displayName));
        });
        return ret;
    }

    @Override
    protected RegistryEntry<ContainerType<T>> createEntryWrapper(RegistryObject<ContainerType<T>> delegate) {
        return new ContainerEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public ContainerEntry<T> register() {
        return (ContainerEntry)super.register();
    }

    public static interface ScreenFactory<C extends Container, T extends Screen> {
        public T create(C var1, PlayerInventory var2, ITextComponent var3);
    }

    public static interface ForgeContainerFactory<T extends Container> {
        public T create(ContainerType<T> var1, int var2, PlayerInventory var3, @Nullable PacketBuffer var4);
    }

    public static interface ContainerFactory<T extends Container> {
        public T create(ContainerType<T> var1, int var2, PlayerInventory var3);
    }
}

