/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.recipe.jobsite;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Function4;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.recipe.SizedIngredient;
import xyz.brassgoggledcoders.transport.recipe.jobsite.SingleItemSizedRecipe;

public class SingleItemSizedRecipeSerializer<T extends SingleItemSizedRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final Function4<ResourceLocation, String, SizedIngredient, ItemStack, T> factory;

    public SingleItemSizedRecipeSerializer(Function4<ResourceLocation, String, SizedIngredient, ItemStack, T> factory) {
        this.factory = factory;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public T read(ResourceLocation recipeId, JsonObject json) {
        ItemStack result;
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        SizedIngredient ingredient = SizedIngredient.fromJson(json.get("ingredient"));
        JsonElement resultElement = json.get("result");
        if (resultElement.isJsonObject()) {
            result = CraftingHelper.getItemStack((JsonObject)resultElement.getAsJsonObject(), (boolean)true);
        } else {
            String itemName = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            int count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            if (item == null) {
                throw new JsonSyntaxException("Unknown item '" + itemName + "'");
            }
            result = new ItemStack((IItemProvider)item, count);
        }
        return (T)((SingleItemSizedRecipe)this.factory.apply((Object)recipeId, (Object)s, (Object)ingredient, (Object)result));
    }

    public T read(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        SizedIngredient ingredient = SizedIngredient.fromBuffer(buffer);
        ItemStack itemstack = buffer.func_150791_c();
        return (T)((SingleItemSizedRecipe)this.factory.apply((Object)recipeId, (Object)group, (Object)ingredient, (Object)itemstack));
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((SingleItemSizedRecipe)recipe).func_193358_e());
        ((SingleItemSizedRecipe)recipe).getIngredient().toBuffer(buffer);
        buffer.func_150788_a(((SingleItemSizedRecipe)recipe).getResult());
    }
}

