/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;

public class SizedIngredient
implements Predicate<ItemStack> {
    private final Ingredient ingredient;
    private final int count;

    public SizedIngredient(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return itemStack.func_190916_E() >= this.count && this.ingredient.test(itemStack);
    }

    public Ingredient getInternal() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public List<ItemStack> getMatchingStacks() {
        ArrayList matchingStacks = Lists.newArrayList();
        for (ItemStack itemStack : this.getInternal().func_193365_a()) {
            ItemStack copy = itemStack.func_77946_l();
            copy.func_190920_e(this.count);
            matchingStacks.add(copy);
        }
        return matchingStacks;
    }

    public void toBuffer(PacketBuffer packetBuffer) {
        this.ingredient.func_199564_a(packetBuffer);
        packetBuffer.writeInt(this.count);
    }

    public JsonElement toJson() {
        JsonElement ingredientJson = this.ingredient.func_200304_c();
        if (ingredientJson.isJsonObject()) {
            JsonObject ingredientJsonObject = ingredientJson.getAsJsonObject();
            if (this.count > 1) {
                ingredientJsonObject.addProperty("count", (Number)this.count);
            }
            return ingredientJsonObject;
        }
        if (ingredientJson.isJsonArray()) {
            if (this.count == 1) {
                return ingredientJson;
            }
            throw new IllegalArgumentException("Failed to properly add count to json: " + ingredientJson);
        }
        throw new IllegalArgumentException("Failed to properly serialize to json: " + ingredientJson.toString());
    }

    public static SizedIngredient fromBuffer(PacketBuffer packetBuffer) {
        return new SizedIngredient(Ingredient.func_199566_b((PacketBuffer)packetBuffer), packetBuffer.readInt());
    }

    public static SizedIngredient fromJson(JsonElement json) {
        return new SizedIngredient(Ingredient.func_199802_a((JsonElement)json), json.isJsonObject() ? JSONUtils.func_151208_a((JsonObject)json.getAsJsonObject(), (String)"count", (int)1) : 1);
    }

    public static SizedIngredient of(Ingredient ingredient) {
        return new SizedIngredient(ingredient, 1);
    }

    public static SizedIngredient of(Ingredient ingredient, int count) {
        return new SizedIngredient(ingredient, count);
    }

    public static SizedIngredient of(ITag<Item> ingredient, int count) {
        return new SizedIngredient(Ingredient.func_199805_a(ingredient), count);
    }
}

