/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.navigation;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationNetwork;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationPoint;
import xyz.brassgoggledcoders.transport.api.navigation.NavigationPointType;

public class NavigationNetwork
implements INavigationNetwork {
    private final Map<UUID, INavigationPoint> navigationPoints = Maps.newHashMap();
    private final Multimap<UUID, INavigationPoint> knownNavigationPoints = Multimaps.newSetMultimap((Map)Maps.newHashMap(), Sets::newHashSet);

    @Override
    @Nonnull
    public Collection<INavigationPoint> getNavigationPoints() {
        return this.navigationPoints.values();
    }

    @Override
    public boolean addNavigationPoint(@Nonnull INavigationPoint navigationPoint) {
        if (!this.navigationPoints.containsKey(navigationPoint.getUniqueId())) {
            this.navigationPoints.put(navigationPoint.getUniqueId(), navigationPoint);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public INavigationPoint removeNavigationPoint(@Nonnull UUID uniqueId) {
        return this.navigationPoints.remove(uniqueId);
    }

    @Override
    @Nullable
    public INavigationPoint getNavigationPoint(@Nonnull UUID uniqueId) {
        return this.navigationPoints.get(uniqueId);
    }

    @Override
    @Nonnull
    public Collection<INavigationPoint> getKnownNavigationPoints(@Nonnull PlayerEntity playerEntity) {
        return this.knownNavigationPoints.get((Object)playerEntity.func_110124_au());
    }

    @Override
    public boolean setKnownNavigationPoint(@Nonnull PlayerEntity playerEntity, @Nonnull INavigationPoint navigationPoint, boolean known) {
        if (known) {
            return this.knownNavigationPoints.get((Object)playerEntity.func_110124_au()).add(navigationPoint);
        }
        return this.knownNavigationPoints.get((Object)playerEntity.func_110124_au()).remove(navigationPoint);
    }

    @Override
    @Nonnull
    public INavigationPoint createPoint(@Nonnull NavigationPointType pointType) {
        return pointType.create(this);
    }

    @Nonnull
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        ListNBT navigationPointListNBT = new ListNBT();
        for (INavigationPoint navigationPoint : this.navigationPoints.values()) {
            navigationPointListNBT.add((Object)NavigationPointType.serialize(navigationPoint));
        }
        compoundNBT.func_218657_a("navigationPoints", (INBT)navigationPointListNBT);
        CompoundNBT knownNavigationPointsNBT = new CompoundNBT();
        for (Map.Entry entry : this.knownNavigationPoints.asMap().entrySet()) {
            ListNBT playerKnownNavigationPointListNBT = new ListNBT();
            for (INavigationPoint navigationPoint : (Collection)entry.getValue()) {
                playerKnownNavigationPointListNBT.add((Object)NBTUtil.func_240626_a_((UUID)navigationPoint.getUniqueId()));
            }
            knownNavigationPointsNBT.func_218657_a(((UUID)entry.getKey()).toString(), (INBT)playerKnownNavigationPointListNBT);
        }
        compoundNBT.func_218657_a("knownNavigationPoints", (INBT)knownNavigationPointsNBT);
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.navigationPoints.clear();
        this.knownNavigationPoints.clear();
        ListNBT navigationPointsListNBT = nbt.func_150295_c("navigationPoints", 10);
        for (int x = 0; x < navigationPointsListNBT.size(); ++x) {
            INavigationPoint navigationPoint = NavigationPointType.deserialize(this, navigationPointsListNBT.func_150305_b(x));
            if (navigationPoint == null) continue;
            this.navigationPoints.put(navigationPoint.getUniqueId(), navigationPoint);
        }
        CompoundNBT knownNavigationPointsNBT = nbt.func_74775_l("knownNavigationPoints");
        for (String key : knownNavigationPointsNBT.func_150296_c()) {
            UUID uniqueId = UUID.fromString(key);
            ListNBT playerKnownNavigationPointsListNBT = knownNavigationPointsNBT.func_150295_c(key, 11);
            for (INBT playerKnownNavigationPoint : playerKnownNavigationPointsListNBT) {
                UUID navigationPointUniqueId = NBTUtil.func_186860_b((INBT)playerKnownNavigationPoint);
                INavigationPoint navigationPoint = this.navigationPoints.get(navigationPointUniqueId);
                if (navigationPoint == null) continue;
                this.knownNavigationPoints.get((Object)uniqueId).add(navigationPoint);
            }
        }
    }
}

