/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.navigation;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationNetwork;
import xyz.brassgoggledcoders.transport.api.navigation.INavigator;
import xyz.brassgoggledcoders.transport.api.navigation.NavigationPoint;
import xyz.brassgoggledcoders.transport.api.navigation.NavigationPointType;

public class ConnectorNavigationPoint
extends NavigationPoint {
    private final Collection<UUID> connectedPoints = Sets.newHashSet();

    public ConnectorNavigationPoint(INavigationNetwork navigationNetwork, NavigationPointType pointType) {
        super(navigationNetwork, pointType);
    }

    public boolean addConnectedPoint(NavigationPoint navigationPoint) {
        if (this.connectedPoints.size() < 2) {
            return this.connectedPoints.add(navigationPoint.getUniqueId());
        }
        return false;
    }

    public Collection<UUID> getConnectedPoints() {
        return this.connectedPoints;
    }

    @Override
    public void alertApproach(@Nonnull INavigator navigator, @Nonnull Entity entity) {
        super.alertApproach(navigator, entity);
        if (this.connectedPoints.contains(navigator.getLastPointId())) {
            // empty if block
        }
    }
}

