/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.entity.locomotive;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.brassgoggledcoders.transport.container.locomotive.SteamLocomotiveContainer;
import xyz.brassgoggledcoders.transport.container.provider.EntityContainerProvider;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.engine.SteamEngine;
import xyz.brassgoggledcoders.transport.entity.locomotive.LocomotiveEntity;
import xyz.brassgoggledcoders.transport.util.LazyOptionalHelper;

public class SteamLocomotiveEntity
extends LocomotiveEntity<SteamEngine> {
    public SteamLocomotiveEntity(EntityType<? extends SteamLocomotiveEntity> type, World world) {
        super(type, world);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_130014_f_().func_201670_d() && this.isPowered() && this.field_70146_Z.nextInt(4) == 0) {
            double clientRadians = Math.toRadians(this.getClientAngle());
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() - 0.9 * Math.cos(clientRadians), this.func_226278_cu_() + 2.2, this.func_226281_cx_() - 0.9 * Math.sin(clientRadians), 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!player.func_213453_ef()) {
            if (!FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)((SteamEngine)this.getEngine()).getWaterTank()) && player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), new EntityContainerProvider<SteamLocomotiveEntity>(this, SteamLocomotiveContainer::new));
            }
            return ActionResultType.func_233537_a_((boolean)this.func_130014_f_().func_201670_d());
        }
        return super.func_184230_a(player, hand);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return LazyOptionalHelper.getOrElse(((SteamEngine)this.getEngine()).getCapability(cap, side), () -> super.getCapability(cap, side));
    }

    public void invalidateCaps() {
        ((SteamEngine)this.getEngine()).invalidateCaps();
        super.invalidateCaps();
    }

    @Override
    public SteamEngine createEngine() {
        return new SteamEngine(this::isOn);
    }

    @Override
    @Nonnull
    public ItemStack createItemStack() {
        return new ItemStack((IItemProvider)TransportEntities.STEAM_LOCOMOTIVE_ITEM.get());
    }
}

