/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.entity.locomotive;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.api.engine.EngineState;
import xyz.brassgoggledcoders.transport.api.entity.IHoldable;
import xyz.brassgoggledcoders.transport.content.TransportItemTags;
import xyz.brassgoggledcoders.transport.engine.Engine;

public abstract class LocomotiveEntity<T extends Engine>
extends AbstractMinecartEntity
implements IHoldable {
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(LocomotiveEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final NonNullLazy<ItemStack> getRenderItemStack;
    private final NonNullLazy<ResourceLocation> getTextureLocation;
    private double previousPushX;
    private double previousPushZ;
    private double pushX;
    private double pushZ;
    private double clientAngle;
    private int held;
    private final T engine;
    private boolean on;
    private EngineState previousMovingEngineState = EngineState.FORWARD_1;
    private EngineState engineState = EngineState.NEUTRAL_0;

    public LocomotiveEntity(EntityType<? extends LocomotiveEntity> type, World world) {
        super(type, world);
        this.engine = this.createEngine();
        this.getRenderItemStack = NonNullLazy.of(this::createItemStack);
        this.getTextureLocation = NonNullLazy.of(this::createTextureLocation);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.FURNACE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)true);
    }

    public void func_70071_h_() {
        ((Engine)this.engine).tick();
        if (this.held > 0) {
            --this.held;
        }
        if (!this.field_70170_p.func_201670_d()) {
            if (this.on && ((Engine)this.engine).pullPower(this.engineState) && this.held <= 0) {
                if (this.pushX == 0.0 || this.pushZ == 0.0) {
                    this.pushX = this.previousPushX;
                    this.pushZ = this.previousPushZ;
                }
                if (!this.isPowered()) {
                    this.setPowered(true);
                }
            } else {
                if (this.pushX != 0.0) {
                    this.previousPushX = this.pushX;
                    this.pushX = 0.0;
                }
                if (this.pushZ != 0.0) {
                    this.previousPushZ = this.pushZ;
                    this.pushZ = 0.0;
                }
                if (this.isPowered()) {
                    this.setPowered(false);
                }
            }
        }
        super.func_70071_h_();
    }

    protected double func_174898_m() {
        return 0.4;
    }

    public double getMaxSpeedWithRail() {
        if (this.canUseRail()) {
            BlockPos pos = this.getCurrentRailPosition();
            BlockState state = this.getMinecart().field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (state.func_235714_a_((ITag)BlockTags.field_203437_y) && block instanceof AbstractRailBlock) {
                float railMaxSpeed = ((AbstractRailBlock)block).getRailMaxSpeed(state, this.func_130014_f_(), pos, (AbstractMinecartEntity)this);
                double maxSpeed = Math.min((double)railMaxSpeed, this.func_174898_m() * (double)this.engineState.getMaxSpeedModifier());
                return Math.min(maxSpeed, (double)this.getCurrentCartSpeedCapOnRail());
            }
        }
        return this.func_174898_m();
    }

    @ParametersAreNonnullByDefault
    protected void func_180460_a(BlockPos pos, BlockState state) {
        super.func_180460_a(pos, state);
        Vector3d vector3d = this.func_213322_ci();
        double horizontalMag = LocomotiveEntity.func_213296_b((Vector3d)vector3d);
        double d3 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d3 > 1.0E-4 && horizontalMag > 0.001) {
            double d4 = MathHelper.func_76133_a((double)horizontalMag);
            double d5 = MathHelper.func_76133_a((double)d3);
            this.pushX = vector3d.field_72450_a / d4 * d5;
            this.pushZ = vector3d.field_72449_c / d4 * d5;
        }
    }

    protected void func_94101_h() {
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d0 > 1.0E-7) {
            d0 = MathHelper.func_76133_a((double)d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.8, 0.0, 0.8).func_72441_c(this.pushX, 0.0, this.pushZ));
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.98, 0.0, 0.98));
        }
        super.func_94101_h();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ActionResultType ret = super.func_184230_a(player, hand);
        if (!ret.func_226246_a_()) {
            if (player.func_184586_b(hand).func_77973_b().func_206844_a(TransportItemTags.WRENCHES)) {
                if (player.func_213453_ef()) {
                    if (this.increaseReverse()) {
                        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                    }
                    return ActionResultType.FAIL;
                }
                if (this.increaseForward()) {
                    return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                }
                return ActionResultType.FAIL;
            }
            return ActionResultType.PASS;
        }
        return ret;
    }

    public void func_94095_a(@Nonnull DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            CompoundNBT locomotiveNBT;
            ItemStack itemstack = this.createItemStack();
            if (this.func_145818_k_()) {
                itemstack.func_200302_a(this.func_200201_e());
            }
            if ((locomotiveNBT = this.writeItemStackData()) != null) {
                itemstack.func_196082_o().func_218657_a("locomotiveData", (INBT)locomotiveNBT);
            }
            this.func_199701_a_(itemstack);
        }
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74780_a("previousPushX", this.previousPushX);
        compound.func_74780_a("previousPushZ", this.previousPushZ);
        compound.func_74780_a("pushX", this.pushX);
        compound.func_74780_a("pushZ", this.pushZ);
        compound.func_74757_a("on", this.on);
        compound.func_74778_a("engineState", this.engineState.toString());
        compound.func_74778_a("previousMovingEngineState", this.previousMovingEngineState.toString());
        compound.func_218657_a("engine", (INBT)((Engine)this.engine).serializeNBT());
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.previousPushX = compound.func_74769_h("previousPushX");
        this.previousPushZ = compound.func_74769_h("previousPushZ");
        this.pushX = compound.func_74769_h("pushX");
        this.pushZ = compound.func_74769_h("pushZ");
        this.on = compound.func_74767_n("on");
        this.engineState = EngineState.byName(compound.func_74779_i("engineState"));
        this.previousMovingEngineState = EngineState.byName(compound.func_74779_i("previousMovingEngineState"));
        ((Engine)this.engine).deserializeNBT(compound.func_74775_l("engine"));
    }

    public boolean increaseForward() {
        EngineState forward = EngineState.forward(this.engineState);
        if (forward != null) {
            return this.alterEngineState(forward);
        }
        return false;
    }

    public boolean increaseReverse() {
        EngineState reverse = EngineState.reverse(this.engineState);
        if (reverse != null) {
            return this.alterEngineState(reverse);
        }
        return false;
    }

    public boolean alterEngineState(EngineState newEngineState) {
        if (newEngineState != this.engineState) {
            if (!newEngineState.getDirection().isMoving() && this.engineState.getDirection().isMoving()) {
                this.previousMovingEngineState = this.engineState;
                this.engineState = newEngineState;
                if (this.pushX != 0.0 || this.pushZ != 0.0) {
                    this.previousPushX = this.pushX;
                    this.previousPushZ = this.pushZ;
                    this.pushX = 0.0;
                    this.pushZ = 0.0;
                }
            } else if (newEngineState.getDirection() != this.previousMovingEngineState.getDirection()) {
                this.previousMovingEngineState = this.engineState;
                this.engineState = newEngineState;
                this.previousPushX *= -1.0;
                this.previousPushZ *= -1.0;
                if (this.pushX != 0.0 || this.pushZ != 0.0) {
                    this.pushX *= -1.0;
                    this.pushZ *= -1.0;
                }
            } else {
                this.previousMovingEngineState = this.engineState;
                this.engineState = newEngineState;
                this.pushX = this.previousPushX;
                this.pushZ = this.previousPushZ;
            }
            return true;
        }
        return false;
    }

    protected boolean isPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    protected void setPowered(boolean powered) {
        this.field_70180_af.func_187227_b(POWERED, (Object)powered);
    }

    public void onPlaced(ItemUseContext context) {
        boolean positive = context.func_195992_f().func_176743_c() == Direction.AxisDirection.POSITIVE;
        BlockState blockState = this.field_70170_p.func_180495_p(context.func_195995_a());
        if (AbstractRailBlock.func_208487_j((BlockState)blockState)) {
            RailShape railShape = ((AbstractRailBlock)blockState.func_177230_c()).getRailDirection(blockState, (IBlockReader)this.field_70170_p, context.func_195995_a(), (AbstractMinecartEntity)this);
            switch (railShape) {
                case EAST_WEST: 
                case ASCENDING_EAST: 
                case ASCENDING_WEST: {
                    this.field_70177_z = positive ? 0.0f : 180.0f;
                    break;
                }
                case NORTH_SOUTH: 
                case ASCENDING_NORTH: 
                case ASCENDING_SOUTH: {
                    this.field_70177_z = positive ? 90.0f : 270.0f;
                    break;
                }
            }
        }
        BlockPos pushPos = this.func_233580_cy_().func_177967_a(context.func_195992_f().func_176734_d(), 3);
        this.previousPushX = this.func_226277_ct_() - (double)pushPos.func_177958_n();
        this.previousPushZ = this.func_226281_cx_() - (double)pushPos.func_177952_p();
    }

    public EngineState getEngineState() {
        return this.engineState;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public void setClientAngle(double angle) {
        this.clientAngle = angle;
    }

    public double getClientAngle() {
        return this.clientAngle;
    }

    public T getEngine() {
        return this.engine;
    }

    public abstract T createEngine();

    @Nonnull
    public abstract ItemStack createItemStack();

    public ItemStack getRenderItemStack() {
        return (ItemStack)this.getRenderItemStack.get();
    }

    @Nonnull
    public ResourceLocation createTextureLocation() {
        ResourceLocation registryName = this.func_200600_R().getRegistryName();
        if (registryName == null) {
            registryName = Transport.rl("unknown");
        }
        return new ResourceLocation(registryName.func_110624_b(), "textures/entity/" + registryName.func_110623_a() + ".png");
    }

    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.getTextureLocation.get();
    }

    public void readFromItemStack(ItemStack item) {
        CompoundNBT locomotiveItemData = item.func_179543_a("locomotiveData");
        if (locomotiveItemData != null) {
            this.readItemStackData(locomotiveItemData);
        }
    }

    public CompoundNBT writeItemStackData() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_218657_a("engine", (INBT)((Engine)this.engine).serializeNBT());
        return compoundNBT;
    }

    public void readItemStackData(CompoundNBT compoundNBT) {
        if (compoundNBT.func_74764_b("engine")) {
            ((Engine)this.engine).deserializeNBT(compoundNBT.func_74775_l("engine"));
        }
    }

    @Override
    public void onHeld() {
        this.held = 10;
    }

    @Override
    public void onRelease() {
        this.held = 0;
    }

    @Override
    public void push(float xPush, float zPush) {
    }
}

