/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.entity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.entity.HullType;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.content.TransportHullTypes;

public class HulledBoatEntity
extends BoatEntity
implements IEntityAdditionalSpawnData {
    private HullType hullType = TransportHullTypes.OAK.get();

    public HulledBoatEntity(EntityType<? extends BoatEntity> entityType, World world) {
        super(entityType, world);
    }

    public HulledBoatEntity(@Nullable HullType hullType, World world, double x, double y, double z) {
        this(TransportEntities.HULLED_BOAT.get(), world);
        this.setHullType(hullType);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHullType((HullType)((IForgeRegistry)TransportAPI.HULL_TYPE.get()).getValue(new ResourceLocation(compound.func_74779_i("hull_type"))));
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("hull_type", Objects.requireNonNull(this.hullType.getRegistryName()).toString());
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_192572_a(Objects.requireNonNull(this.getHullType().getRegistryName()));
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.setHullType((HullType)((IForgeRegistry)TransportAPI.HULL_TYPE.get()).getValue(additionalData.func_192575_l()));
    }

    public void setHullType(@Nullable HullType hullType) {
        this.hullType = hullType != null ? hullType : (HullType)TransportHullTypes.OAK.get();
    }

    public HullType getHullType() {
        return this.hullType;
    }

    public boolean showPaddles() {
        return true;
    }

    @Nonnull
    public Item func_184455_j() {
        return this.hullType.func_199767_j();
    }
}

