/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.content;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.api.engine.EngineState;
import xyz.brassgoggledcoders.transport.content.TransportBlockTags;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;
import xyz.brassgoggledcoders.transport.content.TransportItemTags;
import xyz.brassgoggledcoders.transport.recipe.jobsite.RailWorkerBenchRecipeBuilder;
import xyz.brassgoggledcoders.transport.repack.registrate.providers.RegistrateLangProvider;
import xyz.brassgoggledcoders.transport.repack.registrate.providers.RegistrateRecipeProvider;
import xyz.brassgoggledcoders.transport.repack.registrate.providers.RegistrateTagsProvider;

public class TransportAdditionalData {
    private static final List<Pair<IItemProvider, ITag<Item>>> tagInfoList = Lists.newArrayList();

    public static void generateRecipes(RegistrateRecipeProvider recipeProvider) {
        List<Pair<IItemProvider, ITag<Item>>> itemTagList = TransportAdditionalData.getTagInfoList();
        TransportAdditionalData.railBenchRecipes(recipeProvider, itemTagList, TransportItemTags.RAILS_REGULAR, false);
        TransportAdditionalData.railBenchRecipes(recipeProvider, itemTagList, TransportItemTags.RAILS_POWERED, true);
        TransportAdditionalData.railBenchRecipes(recipeProvider, itemTagList, TransportItemTags.RAILS_STRUCTURE, true);
        RailWorkerBenchRecipeBuilder.create((ITag<Item>)Tags.Items.INGOTS_IRON, (IItemProvider)Items.field_234729_dO_).addCriterion("has_item", (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)Items.field_234729_dO_)).build((Consumer<IFinishedRecipe>)recipeProvider, Transport.rl("minecraft_chain_from_forge_ingots_iron"));
    }

    public static void railBenchRecipes(RegistrateRecipeProvider recipeProvider, List<Pair<IItemProvider, ITag<Item>>> itemTagList, ITag.INamedTag<Item> itemTag, boolean includeBasicRail) {
        for (Pair<IItemProvider, ITag<Item>> rail : itemTagList) {
            if (rail.getRight() != itemTag) continue;
            RailWorkerBenchRecipeBuilder.create(itemTag, (IItemProvider)rail.getLeft()).addCriterion("has_item", (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)Items.field_221742_cg)).build((Consumer<IFinishedRecipe>)recipeProvider, Transport.rl(TransportAdditionalData.fixRL(((IItemProvider)rail.getLeft()).func_199767_j().getRegistryName()) + "_from_" + TransportAdditionalData.fixRL(itemTag.func_230234_a_())));
        }
        if (includeBasicRail) {
            RailWorkerBenchRecipeBuilder.create(itemTag, (IItemProvider)Items.field_221742_cg).addCriterion("has_item", (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)Items.field_221742_cg)).build((Consumer<IFinishedRecipe>)recipeProvider, Transport.rl(TransportAdditionalData.fixRL(Items.field_221742_cg.getRegistryName()) + "_from_" + TransportAdditionalData.fixRL(itemTag.func_230234_a_())));
        }
    }

    public static String fixRL(@Nullable ResourceLocation resourceLocation) {
        return resourceLocation != null ? resourceLocation.toString().replace(":", "_").replace("/", "_") : "";
    }

    public static void generateBlockTags(RegistrateTagsProvider<Block> blockTagsProvider) {
        blockTagsProvider.func_240522_a_(TransportBlockTags.RAILS_REGULAR).func_240534_a_((Object[])new Block[]{Blocks.field_150448_aq});
        blockTagsProvider.func_240522_a_(TransportBlockTags.RAILS_POWERED).func_240534_a_((Object[])new Block[]{Blocks.field_196552_aC, Blocks.field_150319_E, Blocks.field_150408_cc});
    }

    public static void generateItemTags(RegistrateTagsProvider<Item> itemTagsProvider) {
        itemTagsProvider.func_240522_a_(TransportItemTags.RAILS_REGULAR).func_240534_a_((Object[])new Item[]{Items.field_221742_cg});
        itemTagsProvider.func_240522_a_(TransportItemTags.RAILS_POWERED).func_240534_a_((Object[])new Item[]{Items.field_221666_au, Items.field_221668_av, Items.field_221872_et});
        itemTagsProvider.func_240522_a_(TransportItemTags.HULLS).func_240531_a_(TransportItemTags.HULLS_BOAT).func_240531_a_(TransportItemTags.HULLS_MINECART);
        itemTagsProvider.func_240522_a_(TransportItemTags.RAILS).func_240531_a_(TransportItemTags.RAILS_IRON).func_240531_a_(TransportItemTags.RAILS_GOLD);
    }

    public static void generateLang(RegistrateLangProvider langProvider) {
        langProvider.add("screen.transport.jei.category.rail_workers_bench", "Rail Worker's Bench");
        langProvider.add("screen.transport.jei.category.module_configurator", "Module Configurator");
        langProvider.add("screen.transport.speed", "Current Speed: %s");
        langProvider.add(EngineState.FORWARD_3.getTranslationKey(), "Forward 3");
        langProvider.add(EngineState.FORWARD_2.getTranslationKey(), "Forward 2");
        langProvider.add(EngineState.FORWARD_1.getTranslationKey(), "Forward 1");
        langProvider.add(EngineState.NEUTRAL_0.getTranslationKey(), "Neutral");
        langProvider.add(EngineState.REVERSE_1.getTranslationKey(), "Reverse 1");
        langProvider.add(EngineState.REVERSE_2.getTranslationKey(), "Reverse 2");
        langProvider.add(EngineState.REVERSE_3.getTranslationKey(), "Reverse 3");
    }

    public static List<Pair<IItemProvider, ITag<Item>>> getTagInfoList() {
        if (tagInfoList.isEmpty()) {
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)Items.field_221742_cg, TransportItemTags.RAILS_REGULAR));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)((IItemProvider)TransportBlocks.SWITCH_RAIL.get()), TransportItemTags.RAILS_REGULAR));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)((IItemProvider)TransportBlocks.WYE_SWITCH_RAIL.get()), TransportItemTags.RAILS_REGULAR));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)((IItemProvider)TransportBlocks.BUMPER_RAIL.get()), TransportItemTags.RAILS_REGULAR));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)((IItemProvider)TransportBlocks.DIAMOND_CROSSING_RAIL.get()), TransportItemTags.RAILS_REGULAR));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)Items.field_221666_au, TransportItemTags.RAILS_POWERED));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)Items.field_221668_av, TransportItemTags.RAILS_POWERED));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)Items.field_221872_et, TransportItemTags.RAILS_POWERED));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)((IItemProvider)TransportBlocks.HOLDING_RAIL.get()), TransportItemTags.RAILS_POWERED));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)((IItemProvider)TransportBlocks.TIMED_HOLDING_RAIL.get()), TransportItemTags.RAILS_POWERED));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)((IItemProvider)TransportBlocks.ELEVATOR_SWITCH_RAIL.get()), TransportItemTags.RAILS_STRUCTURE));
            tagInfoList.add((Pair<IItemProvider, ITag<Item>>)Pair.of((Object)((IItemProvider)TransportBlocks.SCAFFOLDING_RAIL.get()), TransportItemTags.RAILS_STRUCTURE));
        }
        return tagInfoList;
    }
}

