/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.container.jobsite;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.world.World;
import xyz.brassgoggledcoders.transport.container.jobsite.SingleRecipeOutputSlot;
import xyz.brassgoggledcoders.transport.recipe.jobsite.SingleItemSizedRecipe;

public abstract class SingleRecipeContainer<T extends SingleItemSizedRecipe>
extends Container {
    private final IWorldPosCallable worldPosCallable;
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private final World world;
    private List<T> recipes = Lists.newArrayList();
    private ItemStack itemStackInput = ItemStack.field_190927_a;
    final Slot inputInventorySlot;
    final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final IInventory inputInventory = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            SingleRecipeContainer.this.func_75130_a((IInventory)this);
            SingleRecipeContainer.this.inventoryUpdateListener.run();
        }
    };
    private final CraftResultInventory inventory = new CraftResultInventory();
    private final IRecipeType<T> recipeType;

    public SingleRecipeContainer(ContainerType<? extends SingleRecipeContainer<?>> containerType, int windowId, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable, IRecipeType<T> recipeType) {
        super(containerType, windowId);
        this.worldPosCallable = worldPosCallable;
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.recipeType = recipeType;
        this.inputInventorySlot = this.func_75146_a(new Slot(this.inputInventory, 0, 20, 33));
        this.outputInventorySlot = this.func_75146_a(new SingleRecipeOutputSlot((IInventory)this.inventory, 1, 143, 33, this.worldPosCallable, this::attemptCraft));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
        this.func_216958_a(this.selectedRecipe);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.func_221495_b();
    }

    public List<T> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputInventorySlot.func_75216_d() && !this.recipes.isEmpty();
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return SingleRecipeContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)player, (Block)this.getBlock());
    }

    protected abstract Block getBlock();

    public boolean func_75140_a(@Nonnull PlayerEntity player, int id) {
        if (this.validateId(id)) {
            this.selectedRecipe.func_221494_a(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    private boolean validateId(int id) {
        return id >= 0 && id < this.recipes.size();
    }

    public void func_75130_a(@Nonnull IInventory inventory) {
        ItemStack itemstack = this.inputInventorySlot.func_75211_c();
        if (itemstack.func_77973_b() != this.itemStackInput.func_77973_b()) {
            this.itemStackInput = itemstack.func_77946_l();
            this.updateAvailableRecipes(inventory, itemstack);
        }
    }

    private void updateAvailableRecipes(IInventory inventoryIn, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipes = this.world.func_199532_z().func_215370_b(this.recipeType, inventoryIn, this.world);
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.validateId(this.selectedRecipe.func_221495_b())) {
            SingleItemSizedRecipe recipe = (SingleItemSizedRecipe)this.recipes.get(this.selectedRecipe.func_221495_b());
            this.outputInventorySlot.func_75215_d(recipe.func_77572_b(this.inputInventory));
        } else {
            this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean func_94530_a(@Nonnull ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.inventory && super.func_94530_a(stack, slotIn);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack currentItemStack = slot.func_75211_c();
            Item item = currentItemStack.func_77973_b();
            itemstack = currentItemStack.func_77946_l();
            if (index == 1) {
                item.func_77622_d(currentItemStack, player.field_70170_p, player);
                if (!this.func_75135_a(currentItemStack, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(currentItemStack, itemstack);
            } else if (index == 0 ? !this.func_75135_a(currentItemStack, 2, 38, false) : (this.world.func_199532_z().func_215371_a(this.recipeType, (IInventory)new Inventory(new ItemStack[]{currentItemStack}), this.world).isPresent() ? !this.func_75135_a(currentItemStack, 0, 1, false) : (index < 29 ? !this.func_75135_a(currentItemStack, 29, 38, false) : index < 38 && !this.func_75135_a(currentItemStack, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (currentItemStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (currentItemStack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, currentItemStack);
            this.func_75142_b();
        }
        return itemstack;
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        super.func_75134_a(player);
        this.inventory.func_70304_b(1);
        this.worldPosCallable.func_221486_a((world, blockPos) -> this.func_193327_a(player, player.field_70170_p, this.inputInventory));
    }

    private boolean attemptCraft() {
        ItemStack pulledStack;
        SingleItemSizedRecipe recipe = (SingleItemSizedRecipe)this.recipes.get(this.selectedRecipe.func_221495_b());
        int requiredCount = recipe.getIngredient().getCount();
        if (requiredCount > 1) {
            pulledStack = this.inputInventory.func_70298_a(0, recipe.getIngredient().getCount());
            if (!pulledStack.func_190926_b() && pulledStack.func_190916_E() != requiredCount) {
                this.inputInventory.func_70301_a(0).func_190917_f(pulledStack.func_190916_E());
                pulledStack = ItemStack.field_190927_a;
            }
        } else {
            ItemStack itemStack = this.inputInventory.func_70301_a(0);
            if (itemStack.hasContainerItem()) {
                this.inputInventory.func_70299_a(0, itemStack.getContainerItem());
                pulledStack = itemStack;
            } else {
                pulledStack = this.inputInventory.func_70298_a(0, 1);
            }
        }
        this.updateRecipeResultSlot();
        return !pulledStack.func_190926_b();
    }
}

