/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.module;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleType;

public abstract class Module<MOD extends Module<MOD>>
extends ForgeRegistryEntry<MOD>
implements IItemProvider {
    private final BiFunction<MOD, IModularEntity, ? extends ModuleInstance<MOD>> instanceCreator;
    private final Supplier<ModuleType> componentType;
    private String translationKey;
    private ITextComponent name;

    public Module(Supplier<ModuleType> componentType, BiFunction<MOD, IModularEntity, ? extends ModuleInstance<MOD>> instanceCreator) {
        this.componentType = componentType;
        this.instanceCreator = instanceCreator;
    }

    @Nonnull
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)this.componentType.get().getName(), (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        if (this.name == null) {
            this.name = new TranslationTextComponent(this.getTranslationKey());
        }
        return this.name;
    }

    public boolean isValidFor(IModularEntity modularEntity) {
        return true;
    }

    public ModuleType getType() {
        return this.componentType.get();
    }

    public boolean isActive() {
        return true;
    }

    @Nonnull
    public ModuleInstance<MOD> createInstance(IModularEntity carrier) {
        return this.instanceCreator.apply((MOD)((Object)this), carrier);
    }

    @Nullable
    public static Module<?> fromPacketBuffer(PacketBuffer packetBuffer) {
        ModuleType moduleType = TransportAPI.getModuleType(packetBuffer.func_192575_l());
        if (moduleType != null) {
            return moduleType.load(packetBuffer.func_192575_l());
        }
        return null;
    }

    public static void toPacketBuffer(Module<?> module, PacketBuffer packetBuffer) {
        packetBuffer.func_192572_a(Objects.requireNonNull(module.getType().getRegistryName()));
        packetBuffer.func_192572_a(Objects.requireNonNull(module.getRegistryName()));
    }

    public static Module<?> fromCompoundNBT(CompoundNBT compoundNBT) {
        ModuleType moduleType = TransportAPI.getModuleType(compoundNBT.func_74779_i("type"));
        if (moduleType != null) {
            return moduleType.load(compoundNBT.func_74779_i("module"));
        }
        return null;
    }

    public static void toCompoundNBT(Module<?> module, CompoundNBT compoundNBT) {
        compoundNBT.func_74778_a("type", String.valueOf(module.getType().getRegistryName()));
        compoundNBT.func_74778_a("module", String.valueOf(module.getRegistryName()));
    }

    public static Module<?> fromJson(JsonElement jsonElement) {
        if (jsonElement != null && jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String moduleTypeName = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"type");
            ModuleType moduleType = TransportAPI.getModuleType(moduleTypeName);
            if (moduleType != null) {
                String moduleName = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"name");
                Module<?> module = moduleType.load(moduleName);
                if (module != null) {
                    return module;
                }
                throw new JsonParseException("Failed to find Module for name: " + moduleName);
            }
            throw new JsonParseException("Failed to find Module Type for type: " + moduleTypeName);
        }
        throw new JsonParseException("module must be an json object");
    }

    public static JsonObject toJson(Module<?> module) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", Objects.requireNonNull(module.getType().getRegistryName()).toString());
        jsonObject.addProperty("name", Objects.requireNonNull(module.getRegistryName()).toString());
        return jsonObject;
    }
}

