/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class HullType
extends ForgeRegistryEntry<HullType>
implements IItemProvider {
    private final NonNullSupplier<Item> itemSupplier;
    private final Lazy<ResourceLocation> entityTexture;
    private String translationKey;
    private ITextComponent displayName;

    public HullType(Supplier<Item> itemSupplier) {
        this.itemSupplier = () -> {
            if (itemSupplier.get() == null) {
                return (Item)itemSupplier.get();
            }
            return Items.field_190931_a;
        };
        this.entityTexture = Lazy.of(this::getEntityTexture);
    }

    public HullType(RegistryObject<Item> registryObject, Lazy<ResourceLocation> entityTexture) {
        this((NonNullSupplier<Item>)((NonNullSupplier)() -> (Item)registryObject.orElse((IForgeRegistryEntry)Items.field_190931_a)), entityTexture);
    }

    public HullType(NonNullSupplier<Item> itemSupplier, ResourceLocation entityTexture) {
        this(itemSupplier, (Lazy<ResourceLocation>)Lazy.of(() -> {
            if (entityTexture != null) {
                return new ResourceLocation(entityTexture.func_110624_b(), "textures/entity/" + entityTexture.func_110623_a());
            }
            return null;
        }));
    }

    public HullType(NonNullSupplier<Item> itemSupplier, Lazy<ResourceLocation> entityTexture) {
        this.itemSupplier = itemSupplier;
        this.entityTexture = entityTexture;
    }

    @Nullable
    public ResourceLocation getEntityTexture(@Nonnull Entity entity) {
        return (ResourceLocation)this.entityTexture.get();
    }

    @Nullable
    private ResourceLocation getEntityTexture() {
        ResourceLocation registryName = this.getRegistryName();
        if (registryName != null) {
            return new ResourceLocation(registryName.func_110624_b(), "textures/entity/hull/" + registryName.func_110623_a() + ".png");
        }
        return null;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslationTextComponent(this.getTranslationKey());
        }
        return this.displayName;
    }

    @Nonnull
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"hull_type", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    public Collection<RenderMaterial> getRenderMaterials() {
        return Collections.singleton(new RenderMaterial(PlayerContainer.field_226615_c_, (ResourceLocation)this.entityTexture.get()));
    }

    @Nonnull
    public Item func_199767_j() {
        return (Item)this.itemSupplier.get();
    }
}

