/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerRefinery;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityRefineryOutput
extends TileEntityTickableBase
implements IRedstoneControl<TileEntityRefineryOutput>,
IComparatorSupport,
ISerializableTanks,
INamedContainerProvider,
IHeatExchangingTE {
    private TileEntityRefineryController controllerTE = null;
    @DescSynced
    private final SmartSyncTank outputTank = new SmartSyncTank(this, 16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.outputTank);
    private final LazyOptional<IFluidHandler> fluidCapWrapped = LazyOptional.of(() -> new TankWrapper(this.outputTank));
    private final RedstoneController<TileEntityRefineryOutput> rsController = new RedstoneController<TileEntityRefineryOutput>(this);

    public TileEntityRefineryOutput() {
        super((TileEntityType)ModTileEntities.REFINERY_OUTPUT.get());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.outputTank.tick();
    }

    @Override
    public int getComparatorValue() {
        TileEntityRefineryController controller = this.getRefineryController();
        return controller == null ? 0 : controller.getComparatorValue();
    }

    @Override
    public RedstoneController<TileEntityRefineryOutput> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public int getRedstoneMode() {
        TileEntityRefineryController controller = this.getRefineryController();
        return controller == null ? 0 : controller.getRedstoneMode();
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.outputTank);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        TileEntityRefineryController controller = this.getRefineryController();
        return controller == null ? null : new ContainerRefinery(windowId, inventory, controller.func_174877_v());
    }

    public TileEntityRefineryController getRefineryController() {
        if (this.controllerTE != null && this.controllerTE.func_145837_r()) {
            this.controllerTE = null;
        }
        if (this.controllerTE == null) {
            BlockPos checkPos = this.field_174879_c;
            while (this.field_145850_b.func_180495_p(checkPos.func_177977_b()).func_177230_c() == ModBlocks.REFINERY_OUTPUT.get()) {
                checkPos = checkPos.func_177977_b();
            }
            if (this.field_145850_b.func_180495_p(checkPos.func_177977_b()).func_177230_c() == ModBlocks.REFINERY.get()) {
                this.controllerTE = (TileEntityRefineryController)this.field_145850_b.func_175625_s(checkPos.func_177977_b());
            } else {
                for (Direction d : Direction.Plane.HORIZONTAL) {
                    if (this.field_145850_b.func_180495_p(checkPos.func_177972_a(d)).func_177230_c() != ModBlocks.REFINERY.get()) continue;
                    this.controllerTE = (TileEntityRefineryController)this.field_145850_b.func_175625_s(checkPos.func_177972_a(d));
                }
            }
        }
        return this.controllerTE;
    }

    public IFluidTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return side == Direction.DOWN ? this.fluidCap.cast() : this.fluidCapWrapped.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.fluidCap.invalidate();
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    private static class TankWrapper
    implements IFluidHandler {
        private final SmartSyncTank wrapped;

        TankWrapper(SmartSyncTank wrapped) {
            this.wrapped = wrapped;
        }

        public int getTanks() {
            return this.wrapped.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.wrapped.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.wrapped.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.wrapped.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.wrapped.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.wrapped.drain(maxDrain, action);
        }
    }
}

