/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerLiquidHopper;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAbstractHopper;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityLiquidHopper
extends TileEntityAbstractHopper<TileEntityLiquidHopper>
implements ISerializableTanks {
    private int comparatorValue = -1;
    @DescSynced
    @GuiSynced
    private final HopperTank tank = new HopperTank(16000);
    private final LazyOptional<IFluidHandler> tankCap = LazyOptional.of(() -> this.tank);
    private final WrappedFluidTank inputWrapper = new WrappedFluidTank(this.tank, true);
    private final LazyOptional<IFluidHandler> inputCap = LazyOptional.of(() -> this.inputWrapper);
    private final WrappedFluidTank outputWrapper = new WrappedFluidTank(this.tank, false);
    private final LazyOptional<IFluidHandler> outputCap = LazyOptional.of(() -> this.outputWrapper);
    @GuiSynced
    private final RedstoneController<TileEntityLiquidHopper> rsController = new RedstoneController<TileEntityLiquidHopper>(this);

    public TileEntityLiquidHopper() {
        super((TileEntityType)ModTileEntities.LIQUID_HOPPER.get());
    }

    @Override
    protected int getComparatorValueInternal() {
        if (this.comparatorValue < 0) {
            if (this.tank.getFluidAmount() == 0) {
                return 0;
            }
            FluidStack fluidStack = this.tank.getFluid();
            this.comparatorValue = (int)(1.0f + (float)fluidStack.getAmount() / (float)this.tank.getCapacity() * 14.0f);
        }
        return this.comparatorValue;
    }

    @Override
    public void func_73660_a() {
        FluidStack fluidStack;
        super.func_73660_a();
        this.tank.tick();
        if (!this.field_145850_b.field_72995_K && this.getUpgrades(EnumUpgrade.CREATIVE) > 0 && !(fluidStack = this.tank.getFluid()).isEmpty() && fluidStack.getAmount() < 16000) {
            this.tank.fill(new FluidStack(fluidStack.getFluid(), 16000), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    protected boolean doExport(int maxItems) {
        if (this.tank.getFluid().isEmpty()) {
            return false;
        }
        Direction dir = this.getRotation();
        TileEntity neighbor = this.getCachedNeighbor(dir);
        if (neighbor != null) {
            return IOHelper.getFluidHandlerForTE(neighbor, dir.func_176734_d()).map(fluidHandler -> {
                int amount = Math.min(maxItems * 100, this.tank.getFluid().getAmount() - this.leaveMaterialCount * 1000);
                FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)amount, (boolean)true);
                return !transferred.isEmpty();
            }).orElse(false);
        }
        if (this.getUpgrades(EnumUpgrade.ENTITY_TRACKER) > 0) {
            for (Entity e : this.cachedOutputEntities) {
                FluidStack transferred;
                if (!e.func_70089_S() || (transferred = e.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getRotation().func_176734_d()).map(h -> {
                    int amount = Math.min(maxItems * 100, this.tank.getFluid().getAmount() - this.leaveMaterialCount * 1000);
                    return FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)this.tank, (int)amount, (boolean)true);
                }).orElse(FluidStack.EMPTY)).isEmpty()) continue;
                return true;
            }
        }
        for (Entity e : this.cachedOutputEntities) {
            if (!e.func_70089_S() || !(e instanceof ItemEntity)) continue;
            ItemEntity entity = (ItemEntity)e;
            int maxFill = entity.func_92059_d().func_77973_b() instanceof BucketItem ? 1000 : maxItems * 100;
            FluidActionResult res = FluidUtil.tryFillContainer((ItemStack)entity.func_92059_d(), (IFluidHandler)this.tank, (int)maxFill, null, (boolean)true);
            if (res.success) {
                entity.func_92058_a(res.result);
            }
            if (!this.tank.isEmpty()) continue;
            break;
        }
        if (((Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get()).booleanValue() && this.getUpgrades(EnumUpgrade.DISPENSER) > 0 && this.tank.getFluidAmount() >= this.leaveMaterialCount + 1000) {
            return FluidUtils.tryPourOutFluid(this.outputCap, this.field_145850_b, this.func_174877_v().func_177972_a(dir), false, false, IFluidHandler.FluidAction.EXECUTE);
        }
        return false;
    }

    @Override
    protected boolean doImport(int maxItems) {
        TileEntity inputInv = this.getCachedNeighbor(this.inputDir);
        if (inputInv != null) {
            LazyOptional cap = inputInv.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.inputDir.func_176734_d());
            if (cap.isPresent()) {
                return cap.map(fluidHandler -> {
                    int filledFluid;
                    FluidStack fluid = fluidHandler.drain(maxItems * 100, IFluidHandler.FluidAction.SIMULATE);
                    if (!fluid.isEmpty() && (filledFluid = this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                        fluidHandler.drain(filledFluid, IFluidHandler.FluidAction.EXECUTE);
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
        } else if (this.getUpgrades(EnumUpgrade.ENTITY_TRACKER) > 0) {
            for (Entity e : this.cachedInputEntities) {
                FluidStack transferred;
                if (!e.func_70089_S() || (transferred = e.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.inputDir.func_176734_d()).map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)h, (int)(maxItems * 100), (boolean)true)).orElse(FluidStack.EMPTY)).isEmpty()) continue;
                return true;
            }
        }
        for (Entity e : this.cachedInputEntities) {
            if (!e.func_70089_S() || !(e instanceof ItemEntity)) continue;
            ItemEntity entity = (ItemEntity)e;
            int max = entity.func_92059_d().func_77973_b() instanceof BucketItem ? 1000 : maxItems * 100;
            FluidActionResult res = FluidUtil.tryEmptyContainer((ItemStack)entity.func_92059_d(), (IFluidHandler)this.tank, (int)max, null, (boolean)true);
            if (res.success) {
                entity.func_92058_a(res.result);
            }
            if (this.tank.getFluidAmount() < this.tank.getCapacity()) continue;
            break;
        }
        if (((Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get()).booleanValue() && this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
            BlockPos neighborPos = this.func_174877_v().func_177972_a(this.inputDir);
            return !FluidUtils.tryPickupFluid(this.inputCap, this.field_145850_b, neighborPos, false, IFluidHandler.FluidAction.EXECUTE).isEmpty();
        }
        return false;
    }

    @Override
    protected void setupInputOutputRegions() {
        this.inputAABB = new AxisAlignedBB(this.field_174879_c.func_177972_a(this.inputDir));
        this.outputAABB = new AxisAlignedBB(this.func_174877_v().func_177972_a(this.getRotation()));
        this.cachedInputEntities.clear();
        this.cachedOutputEntities.clear();
    }

    @Override
    boolean shouldScanForEntities(Direction dir) {
        TileEntity te = this.getCachedNeighbor(dir);
        return (te == null || !te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()).isPresent()) && !Block.func_220055_a((IWorldReader)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(dir), (Direction)dir.func_176734_d());
    }

    public HopperTank getTank() {
        return this.tank;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.comparatorValue = -1;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == this.inputDir) {
                return this.inputCap.cast();
            }
            if (facing == this.getRotation()) {
                return this.outputCap.cast();
            }
            return this.tankCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return LazyOptional.empty();
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerLiquidHopper(i, playerInventory, this.func_174877_v());
    }

    @Override
    public RedstoneController<TileEntityLiquidHopper> getRedstoneController() {
        return this.rsController;
    }

    class WrappedFluidTank
    implements IFluidTank,
    IFluidHandler {
        private final IFluidTank wrappedTank;
        private final boolean inbound;

        WrappedFluidTank(IFluidTank wrappedTank, boolean inbound) {
            this.wrappedTank = wrappedTank;
            this.inbound = inbound;
        }

        public FluidStack getFluid() {
            return this.wrappedTank.getFluid();
        }

        public int getFluidAmount() {
            return this.wrappedTank.getFluidAmount();
        }

        public int getCapacity() {
            return this.wrappedTank.getCapacity();
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.wrappedTank.isFluidValid(stack);
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.wrappedTank.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.wrappedTank.getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.wrappedTank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return this.inbound ? this.wrappedTank.fill(resource, doFill) : 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return this.inbound ? FluidStack.EMPTY : TileEntityLiquidHopper.this.tank.drain(resource, doDrain);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return this.inbound ? FluidStack.EMPTY : this.wrappedTank.drain(maxDrain, doDrain);
        }
    }

    public class HopperTank
    extends SmartSyncTank {
        HopperTank(int capacity) {
            super(TileEntityLiquidHopper.this, capacity);
        }

        @Override
        protected void onContentsChanged(Fluid prevFluid, int prevAmount) {
            super.onContentsChanged(prevFluid, prevAmount);
            TileEntityLiquidHopper.this.comparatorValue = -1;
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            int filled = super.fill(resource, doFill);
            if (TileEntityLiquidHopper.this.isCreative && this.getFluidAmount() > 0 && this.getFluid().getFluid() == resource.getFluid()) {
                return resource.getAmount();
            }
            return filled;
        }

        @Override
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return super.drain(resource, TileEntityLiquidHopper.this.isCreative ? IFluidHandler.FluidAction.SIMULATE : doDrain);
        }

        @Override
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return super.drain(maxDrain, TileEntityLiquidHopper.this.isCreative ? IFluidHandler.FluidAction.SIMULATE : doDrain);
        }
    }
}

