/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.IResettable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public abstract class TileEntityAssemblyRobot
extends TileEntityTickableBase
implements IAssemblyMachine,
IResettable {
    public final float[] oldAngles = new float[EnumAngles.values().length];
    @DescSynced
    @LazySynced
    public final float[] angles = new float[EnumAngles.values().length];
    @DescSynced
    final float[] targetAngles = new float[EnumAngles.values().length];
    TargetDirections targetDirection = null;
    @DescSynced
    boolean slowMode;
    @DescSynced
    protected float speed = 1.0f;
    private BlockPos controllerPos;

    TileEntityAssemblyRobot(TileEntityType type) {
        super(type);
        this.gotoHomePosition();
        System.arraycopy(this.targetAngles, 0, this.angles, 0, this.targetAngles.length);
        System.arraycopy(this.targetAngles, 0, this.oldAngles, 0, this.targetAngles.length);
    }

    @Override
    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        if (this.controllerPos != null) {
            PneumaticCraftUtils.getTileEntityAt((IBlockReader)this.func_145831_w(), this.controllerPos, TileEntityAssemblyController.class).ifPresent(TileEntityAssemblyController::invalidateAssemblySystem);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        System.arraycopy(this.angles, 0, this.oldAngles, 0, this.angles.length);
        for (int i = 0; i < this.angles.length; ++i) {
            if (this.angles[i] > this.targetAngles[i]) {
                this.angles[i] = Math.max(this.angles[i] - 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
                continue;
            }
            if (!(this.angles[i] < this.targetAngles[i])) continue;
            this.angles[i] = Math.min(this.angles[i] + 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
        }
    }

    public void gotoHomePosition() {
        for (EnumAngles angle : EnumAngles.values()) {
            this.targetAngles[angle.getIndex()] = angle.getHomeAngle();
        }
    }

    boolean gotoTarget() {
        if (this.targetDirection != null) {
            this.gotoNeighbour(this.targetDirection);
            return this.isDoneMoving();
        }
        return false;
    }

    boolean hoverOverTarget() {
        if (this.targetDirection != null) {
            this.hoverOverNeighbour(this.targetDirection);
            return this.isDoneMoving();
        }
        return false;
    }

    public boolean gotoNeighbour(@Nonnull TargetDirections newDirections) {
        this.targetDirection = newDirections;
        boolean diagonal = true;
        boolean diagonalAllowed = this.canMoveToDiagonalNeighbours();
        switch (this.targetDirection.primary) {
            case SOUTH: {
                if (this.targetDirection.secondary == Direction.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.getIndex()] = -45.0f;
                    this.targetAngles[EnumAngles.HEAD.getIndex()] = 40.0f;
                    break;
                }
                if (this.targetDirection.secondary == Direction.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.getIndex()] = 45.0f;
                    this.targetAngles[EnumAngles.HEAD.getIndex()] = -40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.getIndex()] = 0.0f;
                this.targetAngles[EnumAngles.HEAD.getIndex()] = 90.0f;
                diagonal = false;
                break;
            }
            case EAST: {
                this.targetAngles[EnumAngles.TURN.getIndex()] = -90.0f;
                this.targetAngles[EnumAngles.HEAD.getIndex()] = 0.0f;
                diagonal = false;
                break;
            }
            case NORTH: {
                if (this.targetDirection.secondary == Direction.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.getIndex()] = -135.0f;
                    this.targetAngles[EnumAngles.HEAD.getIndex()] = -40.0f;
                    break;
                }
                if (this.targetDirection.secondary == Direction.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.getIndex()] = 135.0f;
                    this.targetAngles[EnumAngles.HEAD.getIndex()] = 40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.getIndex()] = 180.0f;
                this.targetAngles[EnumAngles.HEAD.getIndex()] = 90.0f;
                diagonal = false;
                break;
            }
            case WEST: {
                this.targetAngles[EnumAngles.TURN.getIndex()] = 90.0f;
                this.targetAngles[EnumAngles.HEAD.getIndex()] = 0.0f;
                diagonal = false;
            }
        }
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.getIndex()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.getIndex()] = -85.0f;
            this.targetAngles[EnumAngles.TAIL.getIndex()] = -20.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.getIndex()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.getIndex()] = -10.0f;
            this.targetAngles[EnumAngles.TAIL.getIndex()] = 0.0f;
        }
        return diagonal;
    }

    void hoverOverNeighbour(TargetDirections directions) {
        boolean diagonal = this.gotoNeighbour(directions);
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.getIndex()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.getIndex()] = -95.0f;
            this.targetAngles[EnumAngles.TAIL.getIndex()] = -10.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.getIndex()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.getIndex()] = -20.0f;
            this.targetAngles[EnumAngles.TAIL.getIndex()] = 10.0f;
        }
    }

    TileEntity getTileEntityForCurrentDirection() {
        if (this.targetDirection == null) {
            return null;
        }
        if (this.targetDirection.secondary == null) {
            return this.getCachedNeighbor(this.targetDirection.primary);
        }
        return this.func_145831_w().func_175625_s(this.targetDirection.offset(this.getPosition()));
    }

    boolean isDoneMoving() {
        for (int i = 0; i < this.angles.length; ++i) {
            if (PneumaticCraftUtils.epsilonEquals(this.angles[i], this.targetAngles[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        for (int i = 0; i < 5; ++i) {
            this.angles[i] = tag.func_74760_g("angle" + i);
            this.targetAngles[i] = tag.func_74760_g("targetAngle" + i);
        }
        this.slowMode = tag.func_74767_n("slowMode");
        this.speed = tag.func_74760_g("speed");
        this.targetDirection = TargetDirections.readNBT(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < 5; ++i) {
            tag.func_74776_a("angle" + i, this.angles[i]);
            tag.func_74776_a("targetAngle" + i, this.targetAngles[i]);
        }
        tag.func_74757_a("slowMode", this.slowMode);
        tag.func_74776_a("speed", this.speed);
        if (this.targetDirection != null) {
            this.targetDirection.writeNBT(tag);
        }
        return tag;
    }

    protected abstract boolean canMoveToDiagonalNeighbours();

    TargetDirections getPlatformDirection() {
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            if (!(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir)) instanceof TileEntityAssemblyPlatform)) continue;
            return new TargetDirections(dir);
        }
        if (this.canMoveToDiagonalNeighbours()) {
            for (Direction secDir : new Direction[]{Direction.WEST, Direction.EAST}) {
                for (Direction primDir : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
                    if (!(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(primDir).func_177972_a(secDir)) instanceof TileEntityAssemblyPlatform)) continue;
                    return new TargetDirections(primDir, secDir);
                }
            }
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)(this.func_174877_v().func_177956_o() - 1), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 2));
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    static class TargetDirections {
        final Direction primary;
        final Direction secondary;

        TargetDirections(@Nonnull Direction primary, Direction secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        TargetDirections(@Nonnull Direction primary) {
            this(primary, null);
        }

        BlockPos offset(BlockPos initial) {
            return this.secondary == null ? initial.func_177972_a(this.primary) : initial.func_177972_a(this.primary).func_177972_a(this.secondary);
        }

        static TargetDirections readNBT(CompoundNBT tag) {
            if (!tag.func_74764_b("targetDir1")) {
                return null;
            }
            return new TargetDirections(DirectionUtil.VALUES[tag.func_74762_e("targetDir1")], tag.func_74764_b("targetDir2") ? DirectionUtil.VALUES[tag.func_74762_e("targetDir2")] : null);
        }

        void writeNBT(CompoundNBT tag) {
            tag.func_74768_a("targetDir1", this.primary.func_176745_a());
            if (this.secondary != null) {
                tag.func_74768_a("targetDir2", this.secondary.func_176745_a());
            }
        }
    }

    static enum EnumAngles {
        TURN(0),
        BASE(1),
        MIDDLE(2, 55.0f),
        TAIL(3, 35.0f),
        HEAD(4);

        private final int idx;
        private final float homeAngle;

        private EnumAngles(int idx) {
            this(idx, 0.0f);
        }

        private EnumAngles(int idx, float homeAngle) {
            this.idx = idx;
            this.homeAngle = homeAngle;
        }

        public int getIndex() {
            return this.idx;
        }

        public float getHomeAngle() {
            return this.homeAngle;
        }
    }
}

