/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public class JEIPlasticSolidifyingCategory
extends AbstractPNCCategory<PlasticSolidifyingRecipe> {
    JEIPlasticSolidifyingCategory() {
        super(ModCategoryUid.PLASTIC_SOLIDIFYING, PlasticSolidifyingRecipe.class, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.title.plasticSolidifying", new Object[0]), (IDrawable)JEIPlasticSolidifyingCategory.guiHelper().createDrawable(Textures.GUI_JEI_MISC_RECIPES, 0, 0, 82, 18), JEIPlasticSolidifyingCategory.guiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.PLASTIC.get())));
    }

    public void setIngredients(PlasticSolidifyingRecipe recipe, IIngredients ingredients) {
        if (recipe.input instanceof FluidIngredient) {
            ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(((FluidIngredient)recipe.input).getFluidStacks()));
        } else {
            ingredients.setInputIngredients(Collections.singletonList(recipe.input));
        }
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PlasticSolidifyingRecipe recipe, IIngredients ingredients) {
        if (recipe.input instanceof FluidIngredient) {
            recipeLayout.getFluidStacks().init(0, true, 1, 1);
            recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        } else {
            recipeLayout.getItemStacks().init(0, true, 0, 0);
            recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        recipeLayout.getItemStacks().init(1, false, 64, 0);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public List<ITextComponent> getTooltipStrings(PlasticSolidifyingRecipe recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> res = new ArrayList<ITextComponent>();
        if (mouseX >= 23.0 && mouseX <= 60.0) {
            res.addAll(PneumaticCraftUtils.splitStringComponent(I18n.func_135052_a((String)"pneumaticcraft.gui.jei.tooltip.plasticSolidifying", (Object[])new Object[0])));
        }
        return res;
    }

    public static Collection<PlasticSolidifyingRecipe> getAllRecipes() {
        return ImmutableList.of((Object)new PlasticSolidifyingRecipe(FluidIngredient.of(1000, (Fluid)ModFluids.PLASTIC.get()), new ItemStack((IItemProvider)ModItems.PLASTIC.get())), (Object)new PlasticSolidifyingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.PLASTIC_BUCKET.get())}), new ItemStack((IItemProvider)ModItems.PLASTIC.get())));
    }

    static class PlasticSolidifyingRecipe {
        final Ingredient input;
        final ItemStack output;

        PlasticSolidifyingRecipe(Ingredient input, ItemStack output) {
            this.input = input;
            this.output = output;
        }
    }
}

