/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.curios;

import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosUtils {
    private static final Pair<String, Integer> NONE = Pair.of((Object)"", (Object)-1);

    public static void chargeItems(PlayerEntity player, PneumaticEnergyStorage energyStorage, int maxTransfer) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getCurios().forEach((id, stackHandler) -> {
            for (int i = 0; i < stackHandler.getSlots() && energyStorage.getEnergyStored() > 0; ++i) {
                ItemStack stack = stackHandler.getStacks().getStackInSlot(i);
                stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(receivingStorage -> {
                    int energyLeft = energyStorage.getEnergyStored();
                    energyStorage.extractEnergy(receivingStorage.receiveEnergy(Math.min(energyLeft, maxTransfer), false), false);
                });
            }
        }));
    }

    public static ItemStack getStack(PlayerEntity player, String invId, int slot) {
        return CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(handler -> {
            ICurioStacksHandler h = (ICurioStacksHandler)handler.getCurios().get(invId);
            return h == null ? ItemStack.field_190927_a : h.getStacks().getStackInSlot(slot);
        }).orElse(ItemStack.field_190927_a);
    }

    public static Pair<String, Integer> findStack(PlayerEntity player, Predicate<ItemStack> predicate) {
        return CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(handler -> {
            for (Map.Entry entry : handler.getCurios().entrySet()) {
                for (int i = 0; i < ((ICurioStacksHandler)entry.getValue()).getSlots(); ++i) {
                    if (!predicate.test(((ICurioStacksHandler)entry.getValue()).getStacks().getStackInSlot(i))) continue;
                    return Pair.of(entry.getKey(), (Object)i);
                }
            }
            return NONE;
        }).orElse(NONE);
    }

    public static IItemHandler makeCombinedInvWrapper(@Nonnull PlayerEntity player) {
        return (IItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(handler -> new CombinedInvWrapper((IItemHandlerModifiable[])handler.getCurios().values().stream().map(ICurioStacksHandler::getStacks).toArray(IItemHandlerModifiable[]::new))).orElse(new CombinedInvWrapper(new IItemHandlerModifiable[0]));
    }
}

