/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.amadron.AmadronUtil;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeNotifyDeal;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PlayerFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class AmadronPlayerOffer
extends AmadronOffer {
    private final String offeringPlayerName;
    private UUID offeringPlayerId;
    private GlobalPos providingPos;
    private GlobalPos returningPos;
    private int pendingPayments;
    private TileEntity cachedInput;
    private TileEntity cachedOutput;

    private AmadronPlayerOffer(ResourceLocation id, AmadronTradeResource input, AmadronTradeResource output, String playerName, UUID playerId, PlayerFilter whitelist, PlayerFilter blacklist) {
        super(id, input, output, true, 0, -1, 0, whitelist, blacklist);
        this.offeringPlayerName = playerName;
        this.offeringPlayerId = playerId;
        this.inStock = 0;
    }

    public AmadronPlayerOffer(ResourceLocation id, AmadronTradeResource input, AmadronTradeResource output, PlayerEntity offeringPlayer, PlayerFilter whitelist, PlayerFilter blacklist) {
        this(id, input, output, offeringPlayer.func_146103_bH().getName(), offeringPlayer.func_146103_bH().getId(), whitelist, blacklist);
    }

    public AmadronPlayerOffer(ResourceLocation id, AmadronTradeResource input, AmadronTradeResource output, PlayerEntity player) {
        this(id, input, output, player, PlayerFilter.YES, PlayerFilter.NO);
    }

    public AmadronPlayerOffer setProvidingPosition(GlobalPos pos) {
        this.providingPos = pos;
        this.cachedInput = null;
        return this;
    }

    public AmadronPlayerOffer setReturningPosition(GlobalPos pos) {
        this.returningPos = pos;
        this.cachedOutput = null;
        return this;
    }

    public AmadronPlayerOffer getReversedOffer() {
        ResourceLocation reversedId = AmadronPlayerOffer.getReversedId(this.func_199560_c());
        AmadronPlayerOffer reversed = new AmadronPlayerOffer(reversedId, this.getOutput(), this.getInput(), this.offeringPlayerName, this.offeringPlayerId, this.whitelist, this.blacklist);
        reversed.providingPos = this.providingPos;
        reversed.returningPos = this.returningPos;
        reversed.inStock = this.inStock;
        reversed.pendingPayments = this.pendingPayments;
        return reversed;
    }

    public void updatePlayerId() {
        PlayerEntity player = PneumaticCraftUtils.getPlayerFromName(this.offeringPlayerName);
        if (player != null) {
            this.offeringPlayerId = player.func_146103_bH().getId();
        }
    }

    public void addPayment(int payment) {
        this.pendingPayments += payment;
    }

    @Override
    public ITextComponent getVendorName() {
        return new StringTextComponent(this.offeringPlayerName);
    }

    public UUID getPlayerId() {
        return this.offeringPlayerId;
    }

    @Override
    public void onTrade(int tradingAmount, String buyingPlayer) {
        PlayerEntity player = PneumaticCraftUtils.getPlayerFromId(this.offeringPlayerId);
        if (player != null && ((Boolean)ConfigHelper.common().amadron.notifyOfDealMade.get()).booleanValue()) {
            NetworkHandler.sendToPlayer(new PacketAmadronTradeNotifyDeal(this, tradingAmount, buyingPlayer), (ServerPlayerEntity)player);
        }
    }

    @Override
    public boolean isRemovableBy(PlayerEntity player) {
        return this.getPlayerId().equals(player.func_110124_au());
    }

    public void notifyRestock() {
        PlayerEntity player = PneumaticCraftUtils.getPlayerFromId(this.getPlayerId());
        if (player != null) {
            player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.amadronRestocked", this.getDescription(), this.getStock()), false);
        }
    }

    public boolean payout() {
        TileEntity returning = this.getReturningTileEntity();
        if (this.pendingPayments > 0) {
            int pay0 = Math.min(this.pendingPayments, 50);
            int paying = this.getInput().apply(itemStack -> this.getInput().findSpaceInItemOutput(IOHelper.getInventoryForTE(returning), pay0), fluidStack -> this.getInput().findSpaceInFluidOutput(IOHelper.getFluidHandlerForTE(returning), pay0));
            if (paying > 0) {
                this.pendingPayments -= paying;
                this.getInput().accept(itemStack -> DroneRegistry.getInstance().deliverItemsAmazonStyle(this.returningPos, AmadronUtil.buildStacks(itemStack, paying)), fluidStack -> DroneRegistry.getInstance().deliverFluidAmazonStyle(this.returningPos, AmadronUtil.buildFluidStack(fluidStack, paying)));
                return true;
            }
        }
        return false;
    }

    public void returnStock() {
        while (this.inStock > 0) {
            int stock = Math.min(this.inStock, 64);
            this.inStock -= stock;
            this.getOutput().accept(itemStack -> DroneRegistry.getInstance().deliverItemsAmazonStyle(this.providingPos, AmadronUtil.buildStacks(itemStack, stock)), fluidStack -> DroneRegistry.getInstance().deliverFluidAmazonStyle(this.providingPos, AmadronUtil.buildFluidStack(fluidStack, stock)));
        }
    }

    public TileEntity getProvidingTileEntity() {
        if ((this.cachedInput == null || this.cachedInput.func_145837_r()) && this.providingPos != null) {
            this.cachedInput = GlobalPosHelper.getTileEntity(this.providingPos);
        }
        return this.cachedInput;
    }

    TileEntity getReturningTileEntity() {
        if ((this.cachedOutput == null || this.cachedOutput.func_145837_r()) && this.returningPos != null) {
            this.cachedOutput = GlobalPosHelper.getTileEntity(this.returningPos);
        }
        return this.cachedOutput;
    }

    public GlobalPos getProvidingPos() {
        return this.providingPos;
    }

    @Override
    public void write(PacketBuffer buf) {
        super.write(buf);
        buf.func_180714_a(this.offeringPlayerName);
        buf.func_179252_a(this.offeringPlayerId);
        buf.writeBoolean(this.providingPos != null);
        if (this.providingPos != null) {
            PacketUtil.writeGlobalPos(buf, this.providingPos);
        }
        buf.writeBoolean(this.returningPos != null);
        if (this.returningPos != null) {
            PacketUtil.writeGlobalPos(buf, this.returningPos);
        }
        buf.func_150787_b(this.inStock);
        buf.func_150787_b(this.pendingPayments);
    }

    public static AmadronPlayerOffer playerOfferFromBuf(ResourceLocation id, PacketBuffer buf) {
        AmadronRecipe recipe = (AmadronRecipe)((IRecipeSerializer)ModRecipes.AMADRON_OFFERS.get()).func_199426_a_(id, buf);
        if (recipe instanceof AmadronOffer) {
            AmadronOffer offer = (AmadronOffer)recipe;
            AmadronPlayerOffer playerOffer = new AmadronPlayerOffer(offer.func_199560_c(), offer.getInput(), offer.getOutput(), buf.func_150789_c(100), buf.func_179253_g(), offer.whitelist, offer.blacklist);
            if (buf.readBoolean()) {
                playerOffer.setProvidingPosition(PacketUtil.readGlobalPos(buf));
            }
            if (buf.readBoolean()) {
                playerOffer.setReturningPosition(PacketUtil.readGlobalPos(buf));
            }
            playerOffer.inStock = buf.func_150792_a();
            playerOffer.pendingPayments = buf.func_150792_a();
            return playerOffer;
        }
        return null;
    }

    @Override
    public JsonObject toJson(JsonObject json) {
        super.toJson(json);
        json.addProperty("offeringPlayerName", this.offeringPlayerName);
        json.addProperty("offeringPlayerId", this.offeringPlayerId.toString());
        json.addProperty("inStock", (Number)this.inStock);
        json.addProperty("pendingPayments", (Number)this.pendingPayments);
        if (this.providingPos != null) {
            json.add("providingPos", GlobalPosHelper.toJson(this.providingPos));
        }
        if (this.returningPos != null) {
            json.add("returningPos", GlobalPosHelper.toJson(this.returningPos));
        }
        return json;
    }

    public static AmadronPlayerOffer fromJson(JsonObject json) throws CommandSyntaxException {
        ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"id"));
        AmadronRecipe recipe = (AmadronRecipe)((IRecipeSerializer)ModRecipes.AMADRON_OFFERS.get()).func_199425_a_(id, json);
        if (recipe instanceof AmadronOffer) {
            AmadronOffer offer = (AmadronOffer)recipe;
            AmadronPlayerOffer playerOffer = new AmadronPlayerOffer(offer.func_199560_c(), offer.getInput(), offer.getOutput(), json.get("offeringPlayerName").getAsString(), UUID.fromString(json.get("offeringPlayerId").getAsString()), offer.whitelist, offer.blacklist);
            playerOffer.inStock = json.get("inStock").getAsInt();
            playerOffer.pendingPayments = json.get("pendingPayments").getAsInt();
            if (json.has("providingPos")) {
                playerOffer.providingPos = GlobalPosHelper.fromJson(json.get("providingPos").getAsJsonObject());
            }
            if (json.has("returningPos")) {
                playerOffer.returningPos = GlobalPosHelper.fromJson(json.get("returningPos").getAsJsonObject());
            }
            return playerOffer;
        }
        return null;
    }

    @Override
    public boolean equivalentTo(AmadronPlayerOffer otherOffer) {
        return super.equivalentTo(otherOffer) && this.offeringPlayerId.equals(otherOffer.offeringPlayerId);
    }

    @Override
    public String toString() {
        return super.toString() + " - " + this.offeringPlayerName;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AmadronPlayerOffer) {
            AmadronPlayerOffer offer = (AmadronPlayerOffer)o;
            return super.equals(o) && offer.offeringPlayerId.equals(this.offeringPlayerId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.offeringPlayerId.hashCode();
    }

    public static ResourceLocation getReversedId(ResourceLocation id) {
        String s = id.toString();
        return s.endsWith("_rev") ? new ResourceLocation(s.replaceFirst("_rev$", "")) : new ResourceLocation(s + "_rev");
    }
}

