/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;

public enum CraftingRecipeCache {
    INSTANCE;

    private static final int MAX_CACHE_SIZE = 1024;
    private final Int2ObjectLinkedOpenHashMap<Optional<ICraftingRecipe>> recipeCache = new Int2ObjectLinkedOpenHashMap(1024, 0.25f);

    public Optional<ICraftingRecipe> getCachedRecipe(World world, CraftingInventory inv) {
        int key = this.makeKey(inv);
        if (this.recipeCache.containsKey(key)) {
            return (Optional)this.recipeCache.getAndMoveToFirst(key);
        }
        Optional newRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)inv, world);
        if (this.recipeCache.size() == 1024) {
            this.recipeCache.removeLast();
        }
        this.recipeCache.put(key, (Object)newRecipe);
        return newRecipe;
    }

    public void clear() {
        this.recipeCache.clear();
    }

    private int makeKey(CraftingInventory inv) {
        ArrayList<Integer> c = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            c.add(i);
            c.add(stack.func_77973_b().hashCode());
            if (!stack.func_77942_o()) continue;
            c.add(stack.func_77978_p().hashCode());
        }
        return Arrays.hashCode((Object[])c.toArray(new Integer[0]));
    }
}

