/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.semiblock.ISyncableSemiblockItem;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class PacketSyncSemiblock {
    private final int entityID;
    private final PacketBuffer payload;

    public PacketSyncSemiblock(ISemiBlock semiBlock) {
        this.entityID = semiBlock.getTrackingId();
        this.payload = new PacketBuffer(Unpooled.buffer());
        semiBlock.writeToBuf(this.payload);
    }

    PacketSyncSemiblock(PacketBuffer buffer) {
        this.entityID = buffer.readInt();
        int size = buffer.func_150792_a();
        this.payload = new PacketBuffer(Unpooled.buffer());
        buffer.readBytes((ByteBuf)this.payload, size);
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.entityID);
        buffer.func_150787_b(this.payload.writerIndex());
        buffer.writeBytes((ByteBuf)this.payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                this.handleClient();
            } else {
                this.handleServer(((NetworkEvent.Context)ctx.get()).getSender());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleServer(ServerPlayerEntity sender) {
        if (this.entityID == -1) {
            if (sender.field_71070_bA instanceof ISyncableSemiblockItem) {
                ((ISyncableSemiblockItem)sender.field_71070_bA).syncSemiblockItemFromClient((PlayerEntity)sender, this.payload);
            }
        } else {
            this.processEntity((World)sender.func_71121_q());
        }
    }

    private void handleClient() {
        Validate.isTrue((this.entityID >= 0 ? 1 : 0) != 0);
        this.processEntity(ClientUtils.getClientWorld());
    }

    private void processEntity(World world) {
        ISemiBlock semiBlock = ISemiBlock.byTrackingId(world, this.entityID);
        if (semiBlock != null) {
            semiBlock.readFromBuf(this.payload);
        } else {
            Log.warning("PacketSemiBlockSync: did not get expected ISemiBlock entity for entity ID %d", this.entityID);
        }
    }
}

