/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketShiftScrollWheel {
    private final boolean forward;
    private final boolean mainHand;

    public PacketShiftScrollWheel(boolean forward, Hand mainHand) {
        this.forward = forward;
        this.mainHand = mainHand == Hand.MAIN_HAND;
    }

    public PacketShiftScrollWheel(PacketBuffer buf) {
        this.forward = buf.readBoolean();
        this.mainHand = buf.readBoolean();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.forward);
        buf.writeBoolean(this.mainHand);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (stack = player.func_184614_ca()).func_77973_b() instanceof IShiftScrollable) {
                ((IShiftScrollable)stack.func_77973_b()).onShiftScrolled((PlayerEntity)player, this.forward, this.mainHand ? Hand.MAIN_HAND : Hand.OFF_HAND);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

