/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketModWrenchBlock
extends LocationIntPacket {
    private final Direction side;
    private final Hand hand;
    private final int entityID;

    public PacketModWrenchBlock(BlockPos pos, Direction side, Hand hand) {
        super(pos);
        this.side = side;
        this.hand = hand;
        this.entityID = -1;
    }

    public PacketModWrenchBlock(BlockPos pos, Hand hand, int entityID) {
        super(pos);
        this.side = null;
        this.hand = hand;
        this.entityID = entityID;
    }

    public PacketModWrenchBlock(PacketBuffer buffer) {
        super(buffer);
        this.hand = Hand.values()[buffer.readByte()];
        if (buffer.readBoolean()) {
            this.entityID = buffer.readInt();
            this.side = null;
        } else {
            this.side = Direction.values()[buffer.readByte()];
            this.entityID = -1;
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte(this.hand.ordinal());
        if (this.entityID >= 0) {
            buf.writeBoolean(true);
            buf.writeInt(this.entityID);
        } else {
            buf.writeBoolean(false);
            buf.writeByte(this.side.func_176745_a());
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player.field_70170_p.isAreaLoaded(this.pos, 0) && PneumaticCraftUtils.canPlayerReach((PlayerEntity)player, this.pos) && ModdedWrenchUtils.getInstance().isModdedWrench(player.func_184586_b(this.hand))) {
                BlockState state;
                if (this.entityID >= 0) {
                    Entity e = player.field_70170_p.func_73045_a(this.entityID);
                    if (e instanceof IPneumaticWrenchable && e.func_70089_S()) {
                        ((IPneumaticWrenchable)e).onWrenched(player.field_70170_p, (PlayerEntity)player, this.pos, this.side, this.hand);
                    }
                } else if (this.side != null && (state = player.field_70170_p.func_180495_p(this.pos)).func_177230_c() instanceof IPneumaticWrenchable) {
                    ((IPneumaticWrenchable)state.func_177230_c()).onWrenched(player.field_70170_p, (PlayerEntity)player, this.pos, this.side, this.hand);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

